/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.list;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.PageState;

/**
 * The default renderer for list items in a {@link
 * List}. Used by the <code>List</code> component if no renderer is given
 * explicitly.
 *
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/list/DefaultListCellRenderer.java#8 $ */
public class DefaultListCellRenderer implements ListCellRenderer {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/list/DefaultListCellRenderer.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Return a component that has been configured to display
     * the specified value. If <code>isSelected</code> is true, returns a
     * bolded <code>Label</code> containing <code>value.toString()</code>. If
     * <code>isSelected</code> is not true, returns a
     * <code>ControlLink</code> labelled with
     * <code>value.toString()</code>. When the user clicks on the link, that
     * item becomes selected.  */
    public Component getComponent(List list, PageState state, Object value,
                                  String key, int index, boolean isSelected)
    {
        Label l = new Label(value.toString());
        if (isSelected) {
            l.setFontWeight(Label.BOLD);
            return l;
        }
        return new ControlLink(l);
    }
}
