/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import javax.servlet.jsp.JspException;

/**
 * superclass for Define... classes that create option groups, so
 * the nested define:option tags  add the Options to the OptionGroup.
 * We do all the work for all OptionGroups here, and define an
 * abstract method "createOptionGroup" to create the specific optionGroup
 * we need.
 *
 * @author Bill Schneider
 */
public abstract class DefineOptionGroup extends DefineContainer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/DefineOptionGroup.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private OptionGroup m_optionGroup;
    private String m_onSelect;
    private String m_onChange;

    /**
     * subclasses must implement this method to create the option
     * group object.
     */
    abstract OptionGroup createOptionGroup();

    public int doStartTag() throws JspException {
        m_optionGroup = createOptionGroup();
        if (m_onChange != null) {
            m_optionGroup.setOnChange(m_onChange);
        }
        if (m_onSelect != null) {
            m_optionGroup.setOnSelect(m_onSelect);
        }
        int ret = super.doStartTag();
        // must put parameter model in page context after calling supereclass
        pageContext.setAttribute(getName(), m_optionGroup.getParameterModel());
        return ret;
    }

    void addOption(Option opt) {
        m_optionGroup.addOption(opt);
    }

    void selectOption(Option opt) {
        m_optionGroup.setOptionSelected(opt);
    }

    public Component getComponent() {
        return m_optionGroup;
    }

    public void setOnSelect(String code) {
        m_onSelect = code;
    }

    public void setOnChange(String code) {
        m_onChange = code;
    }
}
