/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import com.arsdigita.bebop.Component;
import javax.servlet.jsp.JspException;

/**
 * Base class for instantiating any Bebop component with JSP tags.  It
 * is usually better to make a define:... tag specific to your
 * component class, but you may use this class instead of a specific tag
 * for creating your component.
 * <p>usage:
 * <pre>&lt;define:component classname="component.class.name"/></pre>
 * or
 * <pre>&lt;define:component classname="component.class.name"> ...
 * ...
 * &lt;/define:component></pre>
 */

public class DefineComponentImpl extends DefineContainer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/DefineComponentImpl.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private String m_className;
    private Component m_component;

    public int doStartTag() throws JspException {
        if (m_className == null) {
            throw new JspException("classname must be specified");
        }
        try {
            m_component = (Component)Class.forName(m_className).newInstance();
        } catch (ClassNotFoundException cnfe) {
            throw new JspException(cnfe.toString());
        } catch (InstantiationException ie) {
            throw new JspException(ie.toString());
        } catch (IllegalAccessException iae) {
            throw new JspException(iae.toString());
        }
        return super.doStartTag();
    }

    public Component getComponent() {
        return m_component;
    }

    public void setClassname(String s) {
        m_className = s;
    }
}
