/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.util.MessageType;

/**
 * Form section that takes a text entry component (e.g., TextField)
 * and displays it along with a drop-down box that enables the user to
 * select the input type.
 *
 */
public class TextEntryFormSection extends FormSection
    implements MessageType {

    private Widget m_widget;
    private OptionGroup m_textType = null;

    public TextEntryFormSection(Widget w) {
        super(new GridPanel(2));
        m_widget = w;
        add(m_widget);

        if (w.getParameterModel().getValueClass().equals(String.class)) {
            m_textType = new SingleSelect(w.getName() + ".textType");
            m_textType.addOption(new Option(MessageType.TEXT_PLAIN, "Plain text"));
            m_textType.addOption(new Option(MessageType.TEXT_HTML, "HTML"));
            m_textType.addOption(new Option(MessageType.TEXT_PREFORMATTED, "Preformatted text"));
            add(m_textType);
        } else {
            m_textType = new SingleSelect(w.getName() + ".textType") {
                    public boolean isVisible(PageState ps) {
                        return false;
                    }};
            add(m_textType);
        }
    }

    public void setWidgetValue(PageState ps, Object value) {
        m_widget.setValue(ps, value);
    }

    public Object getWidgetValue(PageState ps) {
        return m_widget.getValue(ps);
    }

    public String getTextType(PageState ps) {
        // Null if it's a Deditor
        if ( m_textType == null ) {
            return MessageType.TEXT_HTML;
        } else {
            return (String) m_textType.getValue(ps);
        }
    }

    public void setTextType(PageState ps, String type) {
        m_textType.setValue(ps, type);
    }

}
