/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.ParameterModel;

/**
 *     A class
 *    representing an HTML <code>SELECT</code> element with
 *    a single selection.
 *
 *    @author Karl Goldstein 
 *    @author Uday Mathur 
 *    @author Rory Solomon 
 *    @author Michael Pih 
 *    @author Christian Brechb&uuml;hler (christian@arsdigita.com)
 *    @version $Id: //core-platform/dev/src/com/arsdigita/bebop/form/SingleSelect.java#8 $ */
public class SingleSelect extends Select {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/SingleSelect.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /** The XML tag.
     *  @return The tag to be used for the top level DOM element
     *  generated for this type of Widget.
     */
    protected String getElementTag() {
        return BEBOP_SELECT;
    }

    /**
     * Creates a new SingleSelect widget, using a StringParameter model
     * with the given parameter name.  Since you can only have one
     * item selected from a SingleSelect, the string parameter returns
     * the value of the selected option.
     * <p>This is equivalent to
     * <code>SingleSelect(new StringParameter(name))</code>
     * @param name the name of the string parameter
     */
    public SingleSelect(String name) {
        super(new StringParameter(name));
    }

    /**
     * Creates a new SingleSelect widget, using the given
     * parameter model.
     * @param model the parameter model
     */
    public SingleSelect(ParameterModel model) {
        super(model);
    }

    /** State that this is a single select
     *  @return false
     */
    public boolean isMultiple() {
        return false;
    }
}
