/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;

/**
 * An event for the {@link com.arsdigita.bebop.Tree} component.
 * Tree will fire this event when one of its nodes is expanded or
 * collapsed.
 *
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/TreeExpansionEvent.java#7 $
 */
public class TreeExpansionEvent extends ActionEvent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/TreeExpansionEvent.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Object m_nodeKey;

    public TreeExpansionEvent(Component source, PageState s, Object nodeKey) {
        super(source, s);
        m_nodeKey = nodeKey;
    }

    /**
     * Get the key for the node that was expanded or collapsed.
     *
     * @return the key for the node that was expanded or collapsed.
     */
    public final Object getNodeKey() {
        return m_nodeKey;
    }

}
