/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import java.util.EventListener;

/**
 * The listener interface for receiving request events. The class that is
 * interested in processing a request event implements this interface, and
 * the object created with that class is registered with a Bebop page, using
 * the Page.addRequestListener method. When the page has finished processing
 * the page state, and is about to pass control to the currently selected
 * component, the pageRequested method will be called.
 *
 * @author David Lutterkort 
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/RequestListener.java#7 $
 *
 * @see ActionEvent
 * @see java.awt.event.ActionListener
 */
public interface RequestListener extends EventListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/RequestListener.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    /**
     * Invoked when an action has been performed.
     *
     * @pre e != null
     */
    void pageRequested(RequestEvent e);
}
