/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ParameterData;

import java.util.EventObject;

/**
 * An event connected to a request parameter.
 *
 * @author David Lutterkort 
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/ParameterEvent.java#7 $
 *
 * @see ParameterListener
 * @see com.arsdigita.bebop.parameters.ParameterModel
 * @see com.arsdigita.bebop.parameters.ParameterData
 */

public class ParameterEvent extends EventObject {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/ParameterEvent.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /* The request specific data about the event */
    private transient ParameterData m_data;
    private transient PageState m_state;

    /**
     * Construct a <code>ParameterEvent</code>
     *
     * @param source the object that originated the event
     * @param data the data for the parameter from the current request
     **/

    public ParameterEvent(Object source,  ParameterData data) {
        super(source);
        m_data = data;
        m_state = PageState.getPageState();
    }


    /**
     * Get the request specific data about the parameter.
     **/

    public final ParameterData getParameterData() {
        return m_data;
    }


    /**
     *
     **/

    public PageState getPageState() {
        return m_state;
    }

}
