/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.demo.workflow;

import java.util.ArrayList;
import java.util.Iterator;


/**
 * This class is a standin for the proper workflow task domain
 * object. Tasks have exactly one <code>process</code> they belong to, a
 * unique <code>key</code> for internal identification, a <code>name</code>
 * to display to the user, one <code>assignee</code> to fake assignments,
 * and a set of tasks they depend on.
 *
 * <p> <b>Warning:</b> This class is only meant for demo purposes. It's use
 * of synchronization will make sure that it becomes a bottleneck under
 * load.
 *
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/demo/workflow/Task.java#8 $
 */
public class Task {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/workflow/Task.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static int s_seq = 1;

    private String m_key;
    private String m_name;
    private String m_assignee;
    private ArrayList m_deps;
    private Process m_process;

    public Task(String name) {
        this(getNextKey(), name);
    }

    public Task(String key, String name) {
        m_key = key;
        m_name = name;
        m_deps = new ArrayList();
    }

    public final synchronized Process getProcess() {
        return m_process;
    }

    public final synchronized void setProcess(Process  v) {
        m_process = v;
    }

    public final synchronized String getKey() {
        return m_key;
    }

    public final synchronized String getName() {
        return m_name;
    }

    public final synchronized void setName(String  v) {
        m_name = v;
    }

    public final synchronized void setAssignee(String a) {
        m_assignee = a;
    }

    public final synchronized String getAssignee() {
        return m_assignee;
    }

    public synchronized void addDependency(Task t) {
        for (Iterator i = dependencies(); i.hasNext(); ) {
            Task d = (Task) i.next();
            if (t.getKey().equals(d.getKey())) {
                return;
            }
        }
        m_deps.add(t);
    }

    public synchronized void removeDependency(Task t) {
        m_deps.remove(m_deps.indexOf(t));
    }

    public synchronized Task getDependency(String key) {
        for (Iterator i = dependencies(); i.hasNext(); ) {
            Task d = (Task) i.next();
            if (key.equals(d.getKey())) {
                return d;
            }
        }
        return null;
    }

    public synchronized Iterator dependencies() {
        return m_deps.iterator();
    }

    public synchronized int dependencyCount() {
        return m_deps.size();
    }

    public synchronized static String getNextKey() {
        return String.valueOf(s_seq++);
    }
}
