/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.demo.workflow;


import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.util.GlobalizationUtil;

public class AdminPane extends SimpleContainer
    implements ActionListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/workflow/AdminPane.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private SingleSelectionModel m_processes;
    private ToggleLink m_addLink;

    private Label m_noSelection;
    private ProcessDisplay m_processDisplay;
    private AddProcess m_addProcess;

    public AdminPane (SingleSelectionModel m, ToggleLink l) {
        super();
        m_processes = m;
        m_addLink = l;

        m_noSelection = new Label(GlobalizationUtil.globalize("bebop.demo.workflow.h4emselect_process_to_view_detailsemh4"),  false);
        add(m_noSelection);

        m_processDisplay = new ProcessDisplay(m);
        add(m_processDisplay);

        m_addProcess = new AddProcess(m, l);
        add(m_addProcess);
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault(m_noSelection, true);
        p.setVisibleDefault(m_processDisplay, false);
        p.setVisibleDefault(m_addProcess, false);
        p.addActionListener( this );
    }

    public void actionPerformed(ActionEvent e) {
        PageState s = e.getPageState();
        boolean proc = m_processes.isSelected(s);
        boolean add = m_addLink.isSelected(s);

        m_noSelection.setVisible(s, ! ( proc || add ));
        m_processDisplay.setVisible(s, proc);
        m_addProcess.setVisible(s, add);
    }

}
