/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.demo;

import com.arsdigita.bebop.BebopMapDispatcher;
import com.arsdigita.bebop.Page;
import java.util.HashMap;

/**
 * Minimal dispatcher class.  Demonstrates building a page using Bebop.
 *
 */
public class MinimalDispatcher extends BebopMapDispatcher {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/MinimalDispatcher.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /** Constructor.  Instantiates the subsite url/page mapping.  */
    public MinimalDispatcher() {
        HashMap m = new HashMap();
        m.put("hello", buildPagePage());
        setMap(m);
    }

    /** build a page demonstrating bebop.Page */
    private static Page buildPagePage() {
        Page page = new Page("Hello, World !");
        page.lock();
        return page;
    }
}
