/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.demo;


import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.util.GlobalizationUtil;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.templating.Templating;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Remnants of the once glorious Bebop dispatcher class.
 * Serves one page on all urls, notifying visitors about the merging
 * of demo-bebop into bebop-demo.
 *
 * */
public class BebopDispatcher implements Dispatcher {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/BebopDispatcher.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Page s_moved = buildPageMoved();

    public void dispatch(HttpServletRequest req,
                         HttpServletResponse resp,
                         RequestContext ctx)
        throws javax.servlet.ServletException, java.io.IOException
    {
        Templating.getPresentationManager()
            .servePage(s_moved.buildDocument(req, resp), req, resp);
    }

    /** notification page, for legacy reasons
     */
    static Page buildPageMoved() {
        Page p = new Page("Relocated");

        p.add(new Label(GlobalizationUtil.globalize("bebop.demo.demobebop_has_been_merged_with_bebopdemo")));
        p.add(new Link( new Label(GlobalizationUtil.globalize("bebop.demo.go_there")),  "../bebop-demo"));
        p.lock();
        return p;
    }
}
