/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;
import com.arsdigita.bebop.util.Color;


/**
 * Encapsulates standard methods to style text in a
 * Bebop component.
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/TextStylable.java#9 $
 * */
abstract public class TextStylable extends SimpleComponent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/TextStylable.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Sets a component's foreground or text color.
     *
     * @param color the color to set for this component
     * @pre color != null
     */
    public void setColor(Color color) {
        setAttribute("color", color.toString());
    }

    /**
     * Sets a component's background color.
     *
     * @param backgroundColor the color to set for this component's background
     * @pre backgroundColor != null
     */
    public void setBackgroundColor(Color backgroundColor) {
        setAttribute("backgroundColor", backgroundColor.toString());
    }

}
