/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.form.Submit;

/**
 * A form section with two buttons (Save and Cancel) aligned to
 * the right.
 *
 * @author Stanislav Freidin 
 */
public class SaveCancelSection extends FormSection {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/SaveCancelSection.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Submit m_saveWidget, m_cancelWidget;

    /**
     * Constructs a new SaveCancelSection.
     */
    public SaveCancelSection() {
        super(new BoxPanel(BoxPanel.HORIZONTAL, false));

        BoxPanel panel = (BoxPanel)getPanel();
        panel.setWidth("2%");
        
        createWidgets();

        add(m_saveWidget, BoxPanel.RIGHT);
        add(m_cancelWidget, BoxPanel.RIGHT);
    }

    public SaveCancelSection(Container c) {
        super(c);
        
        createWidgets();
        add(m_saveWidget);
        add(m_cancelWidget);
    }

    private void createWidgets() {
        m_saveWidget = new Submit("save");
        m_saveWidget.setButtonLabel("Save");

        m_cancelWidget = new Submit("cancel");
        m_cancelWidget.setButtonLabel("Cancel");
    }

    /**
     * Gets the Save button.
     * @return the Save button.
     */
    public Submit getSaveButton() {
        return m_saveWidget;
    }

    /**
     * Gets the Cancel button.
     * @return the Cancel button.
     */
    public Submit getCancelButton() {
        return m_cancelWidget;
    }
}
