/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.PageState;
import com.arsdigita.util.Lockable;

/**
 * Constructs a new {@link PropertySheetModel} for the {@link PropertySheet}.
 * The model will be used to get a list of properties at runtime.
 *
 * @author Stanislav Freidin 
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/PropertySheetModelBuilder.java#8 $
 * @see PropertySheetModel
 */

public interface PropertySheetModelBuilder extends Lockable  {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/PropertySheetModelBuilder.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructs a new {@link PropertySheetModel}.
     *
     * @param sheet the {@link PropertySheet}
     * @param state the page state
     * @return a {@link PropertySheetModel}.
     */
    PropertySheetModel makeModel(PropertySheet sheet, PageState state);

}
