/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.PageState;
import com.arsdigita.util.Lockable;

/**
 * Generates a {@link PropertyEditorModel} for the {@link PropertyEditor}
 * during each request. This class is intended for advanced users only.
 *
 * @author Stanislav Freidin 
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/PropertyEditorModelBuilder.java#9 $
 * @see PropertyEditor
 */
public interface PropertyEditorModelBuilder extends Lockable {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/PropertyEditorModelBuilder.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructs a {@link PropertyEditorModel} for the current request.
     * @param p the parent {@link PropertyEditor}
     * @param s represents the current request
     * @return the {@link PropertyEditorModel} for the current request.
     */
    PropertyEditorModel makeModel(PropertyEditor p, PageState s);

}
