/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;

/**
 * Provides properties for the {@link PropertyEditor} during
 * each request. This class is intended for advanced users only.
 *
 * @author Stanislav Freidin 
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/PropertyEditorModel.java#8 $
 * @see PropertyEditorModelBuilder
 */
public interface PropertyEditorModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/PropertyEditorModel.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Advances to the next property, if possible.
     *
     * @return <code>false</code> if there are no more properties;
     * <code>true</code> otherwise.
     */
    boolean next();

    /**
     * Returns the component that should act as a "button" for editing the
     * property. Typically, this method returns a {@link ControlLink}
     * of some sort. When the link is clicked, the {@link PropertyEditor}
     * will display the pane for editing the property.
     *
     * @return a component (usually a {@link ControlLink}) that will act
     *   as the "button" for editing the property.
     */
    Component getComponent();

    /**
     * Returns the unique key of the current property, usually
     * a simple String.
     *
     * @return the key of the current property.
     */
    Object getKey();
}
