/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;


/**
 * The common interface that is implemented by all
 * Bebop containers. The Container interface extends the Component
 * interface.  A container is simply a component that contains other
 * components.
 *
 * @author David Lutterkort 
 * @author Uday Mathur 
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/Container.java#8 $
 * */
public interface Container extends Component {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Container.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Adds a component to this container.
     *
     * @param pc component to add to this container
     * @pre pc != null
     */
    void add(Component pc);

    /**
     * Adds a component with the specified layout constraints to this
     * container. Layout constraints are defined in each layout container as
     * static ints. To specify multiple constraints, uses bitwise OR.
     *
     * @param pc component to add to this container
     *
     * @param constraints layout constraints (a
     * bitwise OR of static ints in the particular layout)
     *
     * @pre c != null
     */
    void add(Component c, int constraints);

    /**
     * Returns <code>true</code> if this list contains the specified element.
     * More formally, returns <code>true</code> if and only if this list
     * contains at least
     * one element e such that (o==null ? e==null : o.equals(e)).
     * <P>
     * This method returns <code>true</code> only if the object has been
     * directly added to this container. If this container contains another
     * container that contains this object, this method returns
     * <code>false</code>.
     *
     * @param  o element whose presence in this container is to be tested
     *
     * @return <code>true</code> if this container contains the  specified
     * object directly; <code>false</code> otherwise.
     * @pre o != null
     */
    boolean contains(Object o);

    /**
     *  Gets the component
     * at the specified position. Each call to the add method increments
     * the index. Since the user has no control over the index of added
     * components (other than counting each call to the add method),
     * this method should be used in conjunction with indexOf.
     *
     * @param index the index of the item to be retrieved from this
     * container
     *
     * @return the component at the specified position in this container.
     *
     * @pre index >= 0 && index < size()
     * @post return != null */
    Component get(int index);

    /**
     * 
     *
     * @param pc component to search for
     *
     * @return the index in this list of the first occurrence of
     * the specified element, or -1 if this list does not contain this
     * element.
     *
     * @pre pc != null
     * @post contains(pc) implies (return >= 0 && return < size())
     * @post ! contains(pc) implies return == -1
     */
    int indexOf(Component pc);

    /**
     * Returns <code>true</code> if the container contains no components.
     *
     * @return <code>true</code> if this container contains no components;
     * <code>false</code> otherwise.
     * @post return == ( size() == 0 )
     */
    boolean isEmpty();

    /**
     * Returns the number of elements in this container. This does not
     * recursively count components that are indirectly contained in this container.
     *
     * @return the number of components directly in this container.
     * @post size() >= 0
     */
    int size();
}
