/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.util.Assert;

/**
 * The base page class for use with the PageFactory
 * class. It sets two attributes on the XML tag for
 * the bebop:page, namely <code>application</code>
 * and <code>id</code>. The values for these two
 * tags correspond to the parameters passed to the 
 * PageFactory.buildPage method.
 * <p>
 * This class is intended to be subclassed to provide
 * the page infrastructure required by a project, for 
 * example, adding some navigation components.
 * The SimplePage class provides a easy implementation
 * whereby the navigation components can be specified
 * in the enterprise.init file.
 */
public class BasePage extends Page {

    public BasePage(String application,
                    Label title,
                    String id) {
        super(title, new SimpleContainer());
        
        Assert.assertNotNull(application, "application name");
        setAttribute("application", application);

        if (id != null) {
            setAttribute("id", id);
        }
    }
}
