/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.auditing;

import com.arsdigita.kernel.User;
import java.util.Date;

/**
 * Interface required for objects to supply auditing save information.
 *
 *  <p>
 *    
 *  </p>
 *
 * @author Joseph Bank 
 * @version 1.0
 */

public interface AuditingSaveInfo {

    /**
     * Gets the user who is doing the save operation from the current
     * execution environment.  May return null.
     * @return the user.
     */
    public User getSaveUser();

    /**
     * Gets the date for the save operation.
     * @return the date.
     */
    public Date getSaveDate();

    /**
     * Gets the IP address for the save operation from the current
     * execution environment.  May return null.
     * @return the IP address.
     */
    public String getSaveIP();

    /**
     * Supports the prototype factory interface.
     */
    public AuditingSaveInfo newInstance();
}
