/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.result;

import jd.xml.xpath.model.NamespaceContext;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.result.MarkupResultBuilder;
import jd.xml.xslt.result.NamespaceSupport;
import jd.xml.xslt.result.ResultLevel;
import jd.xml.xslt.result.output.Output;

public final class XmlResultBuilder
extends MarkupResultBuilder {
    private boolean printDocTypeDeclaration_;
    private boolean nonWhitespaceTextPrinted_;
    private boolean textPrinted_;
    private XmlLevel level_;
    private boolean[] escapeTextChar_ = ESCAPE_TEXT_CHAR;
    private static final boolean[] WHITESPACE_CHAR = new boolean[128];
    private static final boolean[] ESCAPE_ATTR_CHAR;
    private static final boolean[] ESCAPE_TEXT_CHAR;
    private static final boolean[] ESCAPE_NO_CHAR;

    public XmlResultBuilder(XsltResult xsltResult) {
        super(xsltResult);
    }

    public void startDocument(OutputFormat outputFormat) {
        super.startDocument(outputFormat);
        this.level_ = new XmlLevel();
        this.level_.level = -1;
        this.indent_ = outputFormat.getIndent(false);
        if (!outputFormat.getOmitXmlDeclaration(false)) {
            this.output_.printString("<?xml");
            this.printAttribute("version", outputFormat.getVersion("1.0"));
            this.printAttribute("encoding", this.encoding_.getName());
            if (outputFormat.getStandalone() != null) {
                this.printAttribute("standalone", outputFormat.getStandalone() != false ? "yes" : "no");
            }
            this.output_.printSmallByte('?');
            this.output_.printSmallByte('>');
            this.println();
        }
        this.printDocTypeDeclaration_ = outputFormat.getDocTypeSystem() != null;
    }

    public void startElement(String string, String string2, NamespaceContext namespaceContext, boolean bl) {
        this.flushNode(true);
        this.elementStarted_ = true;
        this.nsSupport_.startElement(string, namespaceContext, this.level_.namespaceContext);
        XmlLevel xmlLevel = this.level_ = (XmlLevel)this.level_.increase();
        xmlLevel.name = string2;
        xmlLevel.isEmpty = true;
        xmlLevel.namespaceContext = namespaceContext;
        xmlLevel.isCDataSectionElement = bl;
    }

    public void endElement() {
        this.flushNode(false);
        this.nsSupport_.endElement();
        Output output = this.output_;
        if (!this.indent_) {
            if (!this.level_.isEmpty) {
                output.printSmallByte('<');
                output.printSmallByte('/');
                output.printString(this.level_.name);
                output.printSmallByte('>');
            }
        } else {
            this.decreasePrintIndent();
            if (!this.level_.isEmpty) {
                this.printLineBreak();
                output.printSmallByte('<');
                output.printSmallByte('/');
                output.printString(this.level_.name);
                output.printSmallByte('>');
            }
        }
        this.level_ = (XmlLevel)this.level_.decrease();
    }

    private void printAttributes() {
        boolean[] blArray = ESCAPE_ATTR_CHAR;
        Output output = this.output_;
        int n = this.attributes_.size();
        int n2 = 0;
        while (n2 < n) {
            output.printSmallByte(' ');
            output.printString(this.attributes_.getName(n2));
            output.printSmallByte('=');
            output.printSmallByte('\"');
            String string = this.attributes_.getValue(n2);
            this.printEscapedText(string, 0, string.length(), blArray);
            output.printSmallByte('\"');
            ++n2;
        }
    }

    public void addProcessingInstruction(String string, String string2) {
        this.flushNode(true);
        if (this.indent_) {
            this.printLineBreak();
        }
        Output output = this.output_;
        output.printSmallByte('<');
        output.printSmallByte('?');
        output.printString(string);
        output.printSmallByte(' ');
        output.printString(string2);
        output.printSmallByte('?');
        output.printSmallByte('>');
    }

    public void addTextUnescaped(String string) {
        this.escapeTextChar_ = ESCAPE_NO_CHAR;
        this.addText(string);
        this.escapeTextChar_ = ESCAPE_TEXT_CHAR;
    }

    public void addText(String string) {
        int n = string.length();
        if (n == 0) {
            return;
        }
        if (this.elementStarted_) {
            this.flushElement(true);
        }
        if (!this.textPrinted_) {
            this.textPrinted_ = true;
            if (this.level_.isCDataSectionElement) {
                this.output_.printString("<![CDATA[");
            }
        }
        int n2 = 0;
        if (this.indent_ && !this.nonWhitespaceTextPrinted_) {
            boolean[] blArray = WHITESPACE_CHAR;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c >= '\u0080' || !blArray[c]) {
                    this.nonWhitespaceTextPrinted_ = true;
                    break;
                }
                this.output_.printSmallByte(c);
                ++n2;
            }
            if (n2 == n) {
                return;
            }
        }
        if (this.level_.isCDataSectionElement) {
            this.printCDataText(string, n2, n);
        } else {
            this.printEscapedText(string, n2, n, this.escapeTextChar_);
        }
    }

    private void printNormalText(String string, int n, int n2) {
        boolean[] blArray = this.escapeTextChar_;
        Output output = this.output_;
        while (n < n2) {
            char c = string.charAt(n);
            if (c < '\u0080') {
                if (!blArray[c]) {
                    output.printSmallByte(c);
                } else {
                    output.printSmallByte('&');
                    switch (c) {
                        case '<': {
                            output.printSmallByte('l');
                            output.printSmallByte('t');
                            break;
                        }
                        case '>': {
                            output.printSmallByte('g');
                            output.printSmallByte('t');
                            break;
                        }
                        case '&': {
                            output.printSmallByte('a');
                            output.printSmallByte('m');
                            output.printSmallByte('p');
                        }
                    }
                    output.printSmallByte(';');
                }
            } else if (!this.encoding_.isPrintable(c)) {
                int n3;
                int n4 = n3 = n < n2 - 1 ? (int)string.charAt(n + 1) : -1;
                if (this.printCharReference(c, n3)) {
                    ++n;
                }
            } else {
                output.printChar(c);
            }
            ++n;
        }
    }

    private void printCDataText(String string, int n, int n2) {
        Output output = this.output_;
        while (n < n2) {
            char c = string.charAt(n);
            if (c < '\u0080') {
                if (c == ']' && n + 2 < n2 && string.charAt(n + 1) == ']' && string.charAt(n + 2) == '>') {
                    output.printString("]]]]><![CDATA[>");
                    n += 2;
                } else {
                    output.printSmallByte(c);
                }
            } else if (!this.encoding_.isPrintable(c)) {
                output.printString("]]>");
                n = this.printCharReference(c, string, n, n2);
                output.printString("<![CDATA[");
            } else {
                output.printChar(c);
            }
            ++n;
        }
    }

    private void printEscapedText(String string, int n, int n2, boolean[] blArray) {
        Output output = this.output_;
        while (n < n2) {
            char c = string.charAt(n);
            if (c < '\u0080') {
                if (!blArray[c]) {
                    output.printSmallByte(c);
                } else {
                    output.printSmallByte('&');
                    switch (c) {
                        case '<': {
                            output.printSmallByte('l');
                            output.printSmallByte('t');
                            break;
                        }
                        case '>': {
                            output.printSmallByte('g');
                            output.printSmallByte('t');
                            break;
                        }
                        case '&': {
                            output.printSmallByte('a');
                            output.printSmallByte('m');
                            output.printSmallByte('p');
                            break;
                        }
                        case '\"': {
                            output.printSmallByte('q');
                            output.printSmallByte('u');
                            output.printSmallByte('o');
                            output.printSmallByte('t');
                            break;
                        }
                        case '\n': {
                            output.printSmallByte('#');
                            output.printSmallByte('x');
                            output.printSmallByte('a');
                        }
                    }
                    output.printSmallByte(';');
                }
            } else if (!this.encoding_.isPrintable(c)) {
                n = this.printCharReference(c, string, n, n2);
            } else {
                output.printChar(c);
            }
            ++n;
        }
    }

    private void printDocTypeDeclaration() {
        Output output = this.output_;
        output.printString("<!DOCTYPE ");
        output.printString(this.level_.name);
        if (this.outputFormat_.getDocTypePublic() != null) {
            output.printString(" PUBLIC \"");
            output.printString(this.outputFormat_.getDocTypePublic());
            output.printSmallByte('\"');
            output.printSmallByte(' ');
            output.printSmallByte('\"');
        } else {
            output.printString(" SYSTEM \"");
        }
        output.printString(this.outputFormat_.getDocTypeSystem());
        output.printSmallByte('\"');
        output.printSmallByte('>');
        this.println();
    }

    protected void printLineBreak() {
        if (!this.nonWhitespaceTextPrinted_) {
            if (!this.outNewLine_) {
                this.println();
            }
            this.printIndent();
        }
        this.nonWhitespaceTextPrinted_ = false;
    }

    protected void flushNode(boolean bl) {
        if (this.elementStarted_) {
            this.flushElement(bl);
        } else if (this.textPrinted_) {
            this.textPrinted_ = false;
            if (this.level_.isCDataSectionElement) {
                this.output_.printString("]]>");
            }
        }
    }

    private void flushElement(boolean bl) {
        this.elementStarted_ = false;
        this.level_.isEmpty = !bl;
        Output output = this.output_;
        if (this.printDocTypeDeclaration_) {
            this.printDocTypeDeclaration_ = false;
            this.printDocTypeDeclaration();
        }
        if (this.indent_) {
            this.printLineBreak();
            output.printSmallByte('<');
            output.printString(this.level_.name);
            this.increasePrintIndent();
        } else {
            output.printSmallByte('<');
            output.printString(this.level_.name);
        }
        NamespaceSupport.Declaration declaration = this.nsSupport_.getElementDeclarations();
        while (declaration != null) {
            this.printAttribute(declaration.getName(), declaration.uri);
            declaration = declaration.next;
        }
        if (this.attributes_.size() > 0) {
            this.printAttributes();
            this.attributes_.clear();
        }
        if (!bl) {
            output.printSmallByte('/');
        }
        output.printSmallByte('>');
    }

    static {
        XmlResultBuilder.WHITESPACE_CHAR[9] = true;
        XmlResultBuilder.WHITESPACE_CHAR[32] = true;
        XmlResultBuilder.WHITESPACE_CHAR[10] = true;
        XmlResultBuilder.WHITESPACE_CHAR[13] = true;
        ESCAPE_TEXT_CHAR = new boolean[128];
        XmlResultBuilder.ESCAPE_TEXT_CHAR[60] = true;
        XmlResultBuilder.ESCAPE_TEXT_CHAR[62] = true;
        XmlResultBuilder.ESCAPE_TEXT_CHAR[38] = true;
        ESCAPE_NO_CHAR = new boolean[128];
        ESCAPE_ATTR_CHAR = new boolean[128];
        XmlResultBuilder.ESCAPE_ATTR_CHAR[60] = true;
        XmlResultBuilder.ESCAPE_ATTR_CHAR[62] = true;
        XmlResultBuilder.ESCAPE_ATTR_CHAR[38] = true;
        XmlResultBuilder.ESCAPE_ATTR_CHAR[34] = true;
        XmlResultBuilder.ESCAPE_ATTR_CHAR[10] = true;
    }

    private static class XmlLevel
    extends ResultLevel {
        public String name;
        public NamespaceContext namespaceContext;
        public boolean isCDataSectionElement;
        public boolean isEmpty;

        private XmlLevel() {
        }

        public ResultLevel create() {
            return new XmlLevel();
        }
    }
}

