/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.util;

import java.util.Hashtable;

public abstract class XmlUtil {
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/XML/2000/xmlns/";
    public static final String XSLT_NAMESPACE_URI = "http://www.w3.org/1999/XSL/Transform";
    public static final String XINCLUDE_NAMESPACE_URI = "http://www.w3.org/2001/XInclude";

    public static boolean isWhitespaceString(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            char c = string.charAt(n);
            if (c > ' ' || c != ' ' && c != '\t' && c != '\r' && c != '\n') {
                return false;
            }
            --n;
        }
        return true;
    }

    public static boolean isWhitespaceString(char[] cArray, int n, int n2) {
        int n3 = n + n2 - 1;
        while (n3 >= n) {
            char c = cArray[n3];
            if (c > ' ' || c != ' ' && c != '\t' && c != '\r' && c != '\n') {
                return false;
            }
            --n3;
        }
        return true;
    }

    public static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static boolean startsSurrogatePair(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    public static boolean isNCNameStartChar(char c) {
        return Character.isLetter(c) || c == '_';
    }

    public static boolean isNCNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '.' || c == '-';
    }

    public static boolean isNCName(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (!XmlUtil.isNCNameStartChar(string.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            if (!XmlUtil.isNCNameChar(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isQName(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return XmlUtil.isNCName(string);
        }
        if (n == 0 || n == string.length() - 1) {
            return false;
        }
        return XmlUtil.isNCName(string.substring(0, n)) && XmlUtil.isNCName(string.substring(n + 1));
    }

    public static String getLocalPart(String string) {
        int n = string.indexOf(58);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        return n == -1 ? null : string.substring(0, n);
    }

    public static Hashtable getPiPseudoAttributes(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(10);
        int n = -1;
        int n2 = 0;
        while ((n = string.indexOf(61, n2 + 1)) != -1) {
            String string2 = string.substring(n2, n).trim();
            if (string2.length() == 0) break;
            String string3 = null;
            int n3 = n + 1;
            while (n3 < string.length()) {
                int n4;
                char c = string.charAt(n3);
                if ((c == '\'' || c == '\"') && (n4 = string.indexOf(c, n3 + 1)) != -1) {
                    string3 = string.substring(n3 + 1, n4);
                    n2 = n4 + 1;
                    break;
                }
                ++n3;
            }
            if (string3 == null) break;
            hashtable.put(string2, string3);
        }
        return hashtable;
    }
}

