/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.OutputStream;

public final class BitVector {
    public byte[] bits;
    private int size;
    private int count = -1;
    private static final byte[] BYTE_COUNTS = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};

    public BitVector(int n) {
        this.size = n;
        this.bits = new byte[(this.size >> 3) + 1];
    }

    public final void set(int n) {
        int n2 = n >> 3;
        this.bits[n2] = (byte)(this.bits[n2] | 1 << (n & 7));
        this.count = -1;
    }

    public final void clear(int n) {
        int n2 = n >> 3;
        this.bits[n2] = (byte)(this.bits[n2] & ~(1 << (n & 7)));
        this.count = -1;
    }

    public final boolean get(int n) {
        return (this.bits[n >> 3] & 1 << (n & 7)) != 0;
    }

    public final int size() {
        return this.size;
    }

    public final int count() {
        if (this.count == -1) {
            int n = 0;
            int n2 = this.bits.length;
            int n3 = 0;
            while (n3 < n2) {
                n += BYTE_COUNTS[this.bits[n3] & 0xFF];
                ++n3;
            }
            this.count = n;
        }
        return this.count;
    }

    public final void write(Directory directory, String string) throws IOException {
        OutputStream outputStream = directory.createFile(string);
        try {
            outputStream.writeInt(this.size());
            outputStream.writeInt(this.count());
            outputStream.writeBytes(this.bits, this.bits.length);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
    }

    public BitVector(Directory directory, String string) throws IOException {
        InputStream inputStream = directory.openFile(string);
        try {
            this.size = inputStream.readInt();
            this.count = inputStream.readInt();
            this.bits = new byte[(this.size >> 3) + 1];
            inputStream.readBytes(this.bits, 0, this.bits.length);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }
}

