/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionList;
import org.apache.xalan.xsltc.compiler.AttributeValue;
import org.apache.xalan.xsltc.compiler.CastExpr;
import org.apache.xalan.xsltc.compiler.Expression;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.StringType;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class TransletOutput
extends Instruction {
    private Expression _filename;
    private static final String MISSING_FILE_ATTR = "The <xsltc:output> element requires a 'file' attribute.";

    TransletOutput() {
    }

    public void display(int indent) {
        this.indent(indent);
        Util.println("TransletOutput: " + this._filename);
    }

    public void parseContents(Parser parser2) {
        String filename = this.getAttribute("file");
        if (filename == null || filename.equals("")) {
            this.reportError(this, parser2, 16, "file");
        }
        this._filename = AttributeValue.create(this, filename, parser2);
        this.parseChildren(parser2);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        Type type = this._filename.typeCheck(stable);
        if (!(type instanceof StringType)) {
            this._filename = new CastExpr(this._filename, Type.String);
        }
        this.typeCheckContents(stable);
        return Type.Void;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        il.append(methodGen.loadHandler());
        int open = cpg.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "openOutputHandler", "(Ljava/lang/String;)Lorg/apache/xalan/xsltc/TransletOutputHandler;");
        int close = cpg.addMethodref("org.apache.xalan.xsltc.runtime.AbstractTranslet", "closeOutputHandler", "(Lorg/apache/xalan/xsltc/TransletOutputHandler;)V");
        il.append(classGen.loadTranslet());
        this._filename.translate(classGen, methodGen);
        il.append(new INVOKEVIRTUAL(open));
        il.append(methodGen.storeHandler());
        this.translateContents(classGen, methodGen);
        il.append(classGen.loadTranslet());
        il.append(methodGen.loadHandler());
        il.append(new INVOKEVIRTUAL(close));
        il.append(methodGen.storeHandler());
    }
}

