#!/bin/bash
set -x

[ -f "$CCM_HOME/conf/waf.conf" ] && . "$CCM_HOME/conf/waf.conf"

if [ -z "$WAF_CLASSPATH" ]
then

  WAF_CLASSPATH="$WAF_CLASSPATH_CUSTOM:$CLASSPATH"

  for dir in `ls -d $CCM_HOME/conf/*`
  do
    WAF_CLASSPATH=$WAF_CLASSPATH:$dir
  done

  if [ -n "$WAF_APPS" ]
  then
    for APP in $WAF_APPS
    do
      [ -f "/usr/share/java/$APP.jar" ] && WAF_CLASSPATH="$WAF_CLASSPATH:/usr/share/java/$APP.jar"
      if [ -d "/usr/share/java/$APP" ]
      then
        for file in `ls /usr/share/java/$APP`
        do
          WAF_CLASSPATH=$WAF_CLASSPATH:/usr/share/java/$APP/$file
        done
      fi
    done
  else
    echo foo
  fi
fi

WAF_CLASSPATH=`echo $WAF_CLASSPATH | sed -e 's/::/:/g' | sed -e 's/:$//' | sed -e 's/^://'`

echo $WAF_CLASSPATH | tr : "\n"

java -cp $WAF_CLASSPATH -Dccm.home=$CCM_HOME $*
