/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.profiler.rdbms;

import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.redhat.persistence.Event;
import com.redhat.persistence.Signature;
import com.redhat.persistence.engine.rdbms.RDBMSProfiler;
import com.redhat.persistence.engine.rdbms.RDBMSStatement;
import com.redhat.persistence.engine.rdbms.StatementLifecycle;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.profiler.rdbms.SQLSummary;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class StatementProfiler
implements RDBMSProfiler {
    private boolean m_isEnabled = false;
    private PrintWriter m_out;
    private final ArrayList m_texts = new ArrayList();
    private final ArrayList m_tables = new ArrayList();
    private final ArrayList m_types = new ArrayList();
    private boolean m_inPhase = false;
    static /* synthetic */ Class class$java$io$PrintWriter;

    public StatementLifecycle getLifecycle(RDBMSStatement statement) {
        if (this.m_isEnabled) {
            Assert.exists(this.m_out, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = StatementProfiler.class$("java.io.PrintWriter")) : class$java$io$PrintWriter);
            String text = statement.getText();
            if (!this.m_texts.contains(text)) {
                this.m_texts.add(text);
            }
            SQLSummary summary = SQLSummary.get(text);
            String[] tables = summary.getTables();
            for (int i = 0; i < tables.length; ++i) {
                if (this.m_tables.contains(tables[i])) continue;
                this.m_tables.add(tables[i]);
            }
            ObjectType type = null;
            Signature sig = statement.getSignature();
            if (sig != null) {
                type = sig.getObjectType();
            } else {
                Iterator it = statement.getEvents().iterator();
                if (it.hasNext()) {
                    Event ev = (Event)it.next();
                    type = ev.getSession().getObjectType(ev.getObject());
                }
            }
            if (type != null && !this.m_types.contains(type)) {
                this.m_types.add(type);
            }
            int textid = this.m_texts.indexOf(text);
            Lifecycle lifecycle = new Lifecycle(statement, textid, summary, type);
            return lifecycle;
        }
        return null;
    }

    public void start() {
        if (Assert.isEnabled()) {
            Assert.truth(this.m_out == null);
        }
        try {
            this.m_out = new PrintWriter(new BufferedWriter(new FileWriter(this.file())));
        }
        catch (IOException ioe) {
            throw new UncheckedWrapperException(ioe);
        }
        this.m_out.write("<?xml version=\"1.0\"?>");
        this.m_out.write("<profile>");
        this.m_isEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Assert.exists(this.m_out, class$java$io$PrintWriter == null ? (class$java$io$PrintWriter = StatementProfiler.class$("java.io.PrintWriter")) : class$java$io$PrintWriter);
        try {
            this.m_isEnabled = false;
            Iterator texts = this.m_texts.iterator();
            int i = 0;
            while (texts.hasNext()) {
                String text = (String)texts.next();
                this.m_out.write("\n");
                this.m_out.write("<text id=\"" + i + "\">");
                this.m_out.write("<![CDATA[" + text + "]]>");
                this.m_out.write("</text>");
                ++i;
            }
            Iterator it = this.m_types.iterator();
            while (it.hasNext()) {
                ObjectType ot = (ObjectType)it.next();
                this.m_out.write("\n");
                this.m_out.write("<type>");
                this.m_out.write(ot.getQualifiedName());
                this.m_out.write("</type>");
            }
            it = this.m_tables.iterator();
            while (it.hasNext()) {
                this.m_out.write("\n");
                this.m_out.write("<table>");
                this.m_out.write((String)it.next());
                this.m_out.write("</table>");
            }
            this.m_out.write("\n");
            this.m_out.write("</profile>");
            this.m_out.flush();
        }
        finally {
            this.m_out.close();
            this.m_out = null;
        }
    }

    private File file() {
        try {
            return File.createTempFile("profile", ".xml");
        }
        catch (IOException ioe) {
            throw new UncheckedWrapperException(ioe);
        }
    }

    private void elem(String tag, String value) {
        this.m_out.write("<" + tag + ">" + value + "</" + tag + ">");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class Lifecycle
    implements StatementLifecycle {
        private final RDBMSStatement m_statement;
        private final int m_text;
        private final SQLSummary m_summary;
        private final ObjectType m_type;
        private long m_begin;

        Lifecycle(RDBMSStatement statement, int text, SQLSummary summary, ObjectType type) {
            this.m_statement = statement;
            this.m_text = text;
            this.m_summary = summary;
            this.m_type = type;
        }

        public void beginPrepare() {
            StatementProfiler.this.m_out.write("\n");
            StatementProfiler.this.m_out.write("<statement");
            StatementProfiler.this.m_out.write(" text=\"" + this.m_text + "\"");
            StatementProfiler.this.m_out.write(" type=\"" + this.m_summary.getType() + "\"");
            StatementProfiler.this.m_out.write(">");
            if (this.m_type != null) {
                StatementProfiler.this.elem("objectType", this.m_type.getQualifiedName());
            }
            String[] tables = this.m_summary.getTables();
            for (int i = 0; i < tables.length; ++i) {
                StatementProfiler.this.elem("table", tables[i]);
            }
            Iterator events = this.m_statement.getEvents().iterator();
            while (events.hasNext()) {
                Event event = (Event)events.next();
                StatementProfiler.this.elem("event", "<![CDATA[" + event.toString() + "]]>");
            }
            StatementProfiler.this.m_out.write("<lifecycle>");
            this.begin("prepare");
        }

        public void endPrepare() {
            this.end("prepare");
        }

        public void endPrepare(SQLException e) {
            this.end("prepare", e);
        }

        public void beginSet(int pos, int type, Object object) {
            this.begin("set");
            StatementProfiler.this.elem("pos", Integer.toString(pos));
            StatementProfiler.this.elem("type", Integer.toString(type));
        }

        public void endSet() {
            this.end("set");
        }

        public void endSet(SQLException e) {
            this.end("set", e);
        }

        public void beginExecute() {
            this.begin("execute");
        }

        public void endExecute(int updateCount) {
            StatementProfiler.this.m_out.write("<updated>");
            StatementProfiler.this.m_out.write(Integer.toString(updateCount));
            StatementProfiler.this.m_out.write("</updated>");
            this.end("execute");
        }

        public void endExecute(SQLException e) {
            this.end("execute", e);
        }

        public void beginNext() {
            this.begin("next");
        }

        public void endNext(boolean hasMore) {
            this.end("next");
        }

        public void endNext(SQLException e) {
            this.end("next", e);
        }

        public void beginGet(String column) {
            this.begin("get");
            StatementProfiler.this.elem("column", column);
        }

        public void endGet(Object result) {
            this.end("get");
        }

        public void endGet(SQLException e) {
            this.end("get", e);
        }

        public void beginClose() {
            this.begin("close");
        }

        public void endClose() {
            this.end("close");
            StatementProfiler.this.m_out.write("</lifecycle>");
            StatementProfiler.this.m_out.write("</statement>");
        }

        public void endClose(SQLException e) {
            this.end("close", e);
            StatementProfiler.this.m_out.write("</lifecycle>");
            StatementProfiler.this.m_out.write("</statement>");
        }

        private long now() {
            return System.currentTimeMillis();
        }

        private void begin() {
            this.m_begin = this.now();
        }

        private void begin(String tag) {
            if (StatementProfiler.this.m_inPhase) {
                throw new IllegalStateException("nested begin");
            }
            StatementProfiler.this.m_inPhase = true;
            this.begin();
            StatementProfiler.this.m_out.write("<" + tag + ">");
        }

        private long end() {
            if (!StatementProfiler.this.m_inPhase) {
                throw new IllegalStateException("end called without begin");
            }
            StatementProfiler.this.m_inPhase = false;
            long elapsed = this.now() - this.m_begin;
            return elapsed;
        }

        private void end(String tag, SQLException e) {
            StatementProfiler.this.elem("millis", Long.toString(this.end()));
            if (e != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                StatementProfiler.this.elem("exception", sw.toString());
            }
            StatementProfiler.this.m_out.write("</" + tag + ">");
        }

        private void end(String tag) {
            this.end(tag, null);
        }
    }
}

