/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.profiler.rdbms;

import com.arsdigita.util.UncheckedWrapperException;
import com.redhat.persistence.common.ParseException;
import com.redhat.persistence.common.SQL;
import com.redhat.persistence.common.SQLParser;
import com.redhat.persistence.common.SQLToken;
import java.io.StringReader;
import java.util.HashMap;

class SQLSummary {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/profiler/rdbms/SQLSummary.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final HashMap SUMMARIES = new HashMap();
    public static final int SELECT = 0;
    public static final int INSERT = 1;
    public static final int UPDATE = 2;
    public static final int DELETE = 3;
    public static final int OPAQUE = 4;
    private static final HashMap TYPES = new HashMap();
    private final int m_type;
    private final String[] m_tables;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLSummary get(String text) {
        HashMap hashMap = SUMMARIES;
        synchronized (hashMap) {
            SQLSummary result = (SQLSummary)SUMMARIES.get(text);
            if (result == null) {
                result = new SQLSummary(text);
                SUMMARIES.put(text, result);
            }
            return result;
        }
    }

    private SQLSummary(String text) {
        String image;
        Integer type;
        SQLParser p = new SQLParser(new StringReader(text));
        try {
            p.sql();
        }
        catch (ParseException e) {
            throw new UncheckedWrapperException(e);
        }
        SQL sql = p.getSQL();
        SQLToken first = sql.getFirst();
        this.m_type = first == null ? 4 : ((type = (Integer)TYPES.get(image = SQLSummary.strip(first.getImage().toLowerCase()))) == null ? 4 : type);
        switch (this.m_type) {
            case 1: 
            case 2: 
            case 3: {
                SQLToken next = first.getNext();
                if (next == null) {
                    this.m_tables = new String[0];
                    break;
                }
                this.m_tables = new String[]{SQLSummary.strip(next.getImage().toLowerCase())};
                break;
            }
            default: {
                this.m_tables = new String[0];
            }
        }
    }

    public int getType() {
        return this.m_type;
    }

    public String[] getTables() {
        return this.m_tables;
    }

    private static final String strip(String str) {
        str = str.trim();
        StringBuffer result = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) {
                char last = result.charAt(result.length() - 1);
                if (last == ' ') continue;
                result.append(' ');
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    static {
        TYPES.put("select", new Integer(0));
        TYPES.put("insert into", new Integer(1));
        TYPES.put("update", new Integer(2));
        TYPES.put("delete from", new Integer(3));
    }
}

