/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.pdl.adapters;

import com.arsdigita.util.AssertionError;
import com.redhat.persistence.pdl.adapters.SimpleAdapter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class DateAd
extends SimpleAdapter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/pdl/adapters/DateAd.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public DateAd() {
        super("global.Date", 93);
    }

    public void bind(PreparedStatement ps, int index, Object obj, int type) throws SQLException {
        Timestamp tstamp = null;
        if (obj instanceof Timestamp) {
            tstamp = (Timestamp)obj;
        } else if (obj instanceof Date) {
            tstamp = new Timestamp(((Date)obj).getTime());
        } else {
            throw new AssertionError("Not a Date: " + (obj == null ? "null" : obj.getClass().getName()));
        }
        ps.setTimestamp(index, tstamp);
    }

    public Object fetch(ResultSet rs, String column) throws SQLException {
        Timestamp tstamp = rs.getTimestamp(column);
        if (tstamp == null) {
            return null;
        }
        return new Date(tstamp.getTime() + (long)(tstamp.getNanos() / 1000000));
    }
}

