/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.pdl;

import com.arsdigita.util.WrappedError;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.common.SQLParser;
import com.redhat.persistence.metadata.Adapter;
import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.Constraint;
import com.redhat.persistence.metadata.DataOperation;
import com.redhat.persistence.metadata.ForeignKey;
import com.redhat.persistence.metadata.JoinFrom;
import com.redhat.persistence.metadata.JoinThrough;
import com.redhat.persistence.metadata.JoinTo;
import com.redhat.persistence.metadata.Link;
import com.redhat.persistence.metadata.Mapping;
import com.redhat.persistence.metadata.Model;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Qualias;
import com.redhat.persistence.metadata.Role;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.metadata.SQLBlock;
import com.redhat.persistence.metadata.Static;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.metadata.UniqueKey;
import com.redhat.persistence.metadata.Value;
import com.redhat.persistence.pdl.ErrorReport;
import com.redhat.persistence.pdl.PDLParser;
import com.redhat.persistence.pdl.ParseException;
import com.redhat.persistence.pdl.SymbolTable;
import com.redhat.persistence.pdl.VersioningMetadata;
import com.redhat.persistence.pdl.nodes.AST;
import com.redhat.persistence.pdl.nodes.AggressiveLoadNd;
import com.redhat.persistence.pdl.nodes.AssociationNd;
import com.redhat.persistence.pdl.nodes.BindingNd;
import com.redhat.persistence.pdl.nodes.ColumnNd;
import com.redhat.persistence.pdl.nodes.DataOperationNd;
import com.redhat.persistence.pdl.nodes.DbTypeNd;
import com.redhat.persistence.pdl.nodes.EventNd;
import com.redhat.persistence.pdl.nodes.FileNd;
import com.redhat.persistence.pdl.nodes.IdentifierNd;
import com.redhat.persistence.pdl.nodes.JavaClassNd;
import com.redhat.persistence.pdl.nodes.JoinNd;
import com.redhat.persistence.pdl.nodes.JoinPathNd;
import com.redhat.persistence.pdl.nodes.MappingNd;
import com.redhat.persistence.pdl.nodes.Node;
import com.redhat.persistence.pdl.nodes.ObjectKeyNd;
import com.redhat.persistence.pdl.nodes.ObjectTypeNd;
import com.redhat.persistence.pdl.nodes.PathNd;
import com.redhat.persistence.pdl.nodes.PropertyNd;
import com.redhat.persistence.pdl.nodes.QualiasNd;
import com.redhat.persistence.pdl.nodes.ReferenceKeyNd;
import com.redhat.persistence.pdl.nodes.SQLBlockNd;
import com.redhat.persistence.pdl.nodes.SuperNd;
import com.redhat.persistence.pdl.nodes.TypeNd;
import com.redhat.persistence.pdl.nodes.UniqueKeyNd;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class PDL {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/pdl/PDL.java#20 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger LOG = Logger.getLogger((Class)(class$com$redhat$persistence$pdl$PDL == null ? (class$com$redhat$persistence$pdl$PDL = PDL.class$("com.redhat.persistence.pdl.PDL")) : class$com$redhat$persistence$pdl$PDL));
    public static final String LINK = "@link";
    private AST m_ast = new AST();
    private boolean m_autoLoad;
    private Root m_root;
    private ErrorReport m_errors;
    private SymbolTable m_symbols;
    private HashSet m_links;
    private HashSet m_fks;
    private HashMap m_propertyCollisions;
    private HashMap m_emitted;
    private HashMap m_nodes;
    private HashMap m_primaryKeys = new HashMap();
    private HashMap m_propByColumns = new HashMap();
    static /* synthetic */ Class class$com$redhat$persistence$pdl$PDL;

    public PDL() {
        this(true);
    }

    private PDL(boolean autoLoad) {
        this.m_autoLoad = autoLoad;
    }

    public void load(Reader r, String filename) {
        try {
            PDLParser p = new PDLParser(r);
            FileNd file = p.file(filename);
            this.m_ast.add(AST.FILES, file);
        }
        catch (ParseException e) {
            throw new WrappedError(filename, e);
        }
    }

    public void loadResource(String s) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(s);
        if (is == null) {
            throw new Error("No such resource: " + s);
        }
        this.load(new InputStreamReader(is), s);
    }

    private void emitGlobal(Root root) {
        PDL glob = new PDL(false);
        glob.loadResource("com/redhat/persistence/pdl/global.pdl");
        glob.emit(root);
    }

    private String linkName(AssociationNd assn) {
        Model m = Model.getInstance(assn.getFile().getModel().getName());
        return m.getQualifiedName() + "." + this.linkName(assn.getRoleOne(), assn.getRoleTwo());
    }

    private String linkName(PropertyNd one, PropertyNd two) {
        return (this.m_symbols.lookup(one.getType()) + ":" + one.getName().getName() + "::" + this.m_symbols.lookup(two.getType()) + ":" + two.getName().getName() + "::Link").replace('.', '_');
    }

    void emit(Node node, Object emitted) {
        this.m_nodes.put(emitted, node);
        this.m_emitted.put(node, emitted);
    }

    Node getNode(Object emitted) {
        return (Node)this.m_nodes.get(emitted);
    }

    Object getEmitted(Node node) {
        return this.m_emitted.get(node);
    }

    public void emit(Root root) {
        this.m_root = root;
        this.m_errors = new ErrorReport();
        this.m_symbols = new SymbolTable(this.m_errors, this.m_root);
        this.m_links = new HashSet();
        this.m_fks = new HashSet();
        this.m_propertyCollisions = new HashMap();
        this.m_emitted = new HashMap();
        this.m_nodes = new HashMap();
        this.m_ast.traverse(new Node.Switch(){

            public void onNode(Node nd) {
                Iterator it = nd.getFields().iterator();
                while (it.hasNext()) {
                    String error = nd.validate((Node.Field)it.next());
                    if (error == null) continue;
                    PDL.this.m_errors.fatal(nd, error);
                }
            }
        });
        this.m_errors.check();
        if (this.m_autoLoad && root.getObjectType("global.String") == null) {
            this.emitGlobal(root);
        }
        Iterator it = this.m_root.getObjectTypes().iterator();
        while (it.hasNext()) {
            this.m_symbols.addEmitted((ObjectType)it.next());
        }
        this.m_ast.traverse(new Node.Switch(){

            public void onObjectType(ObjectTypeNd ot) {
                if (ot.hasReturns()) {
                    PDL.this.m_errors.warn(ot, "returns clause is deprecated");
                }
                PDL.this.m_symbols.define(ot);
            }
        });
        this.m_errors.check();
        this.m_ast.traverse(new Node.Switch(){

            public void onType(TypeNd t) {
                PDL.this.m_symbols.resolve(t);
            }
        });
        this.m_errors.check();
        this.m_symbols.sort();
        this.m_errors.check();
        this.m_symbols.emit();
        this.m_ast.traverse(new Node.Switch(){

            public void onAssociation(AssociationNd assn) {
                if (assn.getProperties().size() == 0) {
                    return;
                }
                ObjectType ot = new ObjectType(Model.getInstance(assn.getFile().getModel().getName()), PDL.this.linkName(assn.getRoleOne(), assn.getRoleTwo()), null);
                PDL.this.m_symbols.addEmitted(ot);
            }
        });
        this.m_ast.traverse(new Node.Switch(){

            private Role define(ObjectType type, PropertyNd prop) {
                String name = prop.getName().getName();
                Property prev = (Property)PDL.this.m_propertyCollisions.get(type.getQualifiedName() + ":" + name);
                if (prev == null) {
                    prev = type.getProperty(name);
                }
                if (prev != null) {
                    PDL.this.m_errors.fatal(prop, "duplicate property: " + name + ", previous definition: " + PDL.this.getNode(prev).getLocation());
                    return null;
                }
                Integer upper = prop.getUpper();
                Integer lower = prop.getLower();
                if (upper != null && upper <= 0 || lower != null && lower < 0 || upper != null && lower != null && upper < lower) {
                    PDL.this.m_errors.fatal(prop, "bad multiplicity: " + name);
                    return null;
                }
                Role result = new Role(prop.getName().getName(), PDL.this.m_symbols.getEmitted(prop.getType()), prop.isComponent(), prop.isCollection(), prop.isNullable());
                PDL.this.m_symbols.setLocation(result, prop);
                type.addProperty(result);
                if (prop.isImmediate()) {
                    type.addImmediateProperty(result);
                }
                PDL.this.emit(prop, result);
                for (ObjectType ot = type; ot != null; ot = ot.getSupertype()) {
                    PDL.this.m_propertyCollisions.put(ot.getQualifiedName() + ":" + name, result);
                }
                return result;
            }

            public void onProperty(PropertyNd prop) {
                ObjectType type = PDL.this.m_symbols.getEmitted((ObjectTypeNd)prop.getParent());
                Role role = this.define(type, prop);
                if (prop.isComposite()) {
                    String rev = "~" + prop.getName().getName() + ":" + type.getQualifiedName().replace('.', '$');
                    Role reverse = new Role(rev, type, true, true, true);
                    role.getType().addProperty(reverse);
                    role.setReverse(reverse);
                }
            }

            public void onAssociation(AssociationNd assn) {
                PropertyNd one = assn.getRoleOne();
                PropertyNd two = assn.getRoleTwo();
                if (one.isComposite()) {
                    two.setComponent();
                }
                if (two.isComposite()) {
                    one.setComponent();
                }
                Collection props = assn.getProperties();
                ObjectType oneot = PDL.this.m_symbols.getEmitted(one.getType());
                ObjectType twoot = PDL.this.m_symbols.getEmitted(two.getType());
                if (props.size() > 0) {
                    Role rone = new Role(one.getName().getName(), oneot, one.isComponent(), false, false);
                    PDL.this.m_symbols.setLocation(rone, one);
                    Role rtwo = new Role(two.getName().getName(), twoot, two.isComponent(), false, false);
                    PDL.this.m_symbols.setLocation(rtwo, two);
                    ObjectType ot = PDL.this.m_symbols.getEmitted(PDL.this.linkName(assn));
                    ot.addProperty(rone);
                    Role revOne = new Role(rtwo.getName() + PDL.LINK, ot, true, two.isCollection(), two.isNullable());
                    rone.getType().addProperty(revOne);
                    rone.setReverse(revOne);
                    ot.addProperty(rtwo);
                    Role revTwo = new Role(rone.getName() + PDL.LINK, ot, true, one.isCollection(), one.isNullable());
                    rtwo.getType().addProperty(revTwo);
                    rtwo.setReverse(revTwo);
                    Iterator it = props.iterator();
                    while (it.hasNext()) {
                        PropertyNd prop = (PropertyNd)it.next();
                        this.define(ot, prop);
                    }
                    Link l = new Link(rone.getName(), rtwo, rone, one.isCollection(), one.isNullable());
                    PDL.this.m_symbols.setLocation(l, one);
                    PDL.this.m_links.add(l);
                    twoot.addProperty(l);
                    l = new Link(rtwo.getName(), rone, rtwo, two.isCollection(), two.isNullable());
                    PDL.this.m_symbols.setLocation(l, two);
                    PDL.this.m_links.add(l);
                    oneot.addProperty(l);
                } else {
                    Role rone = this.define(oneot, two);
                    Role rtwo = this.define(twoot, one);
                    if (rone != null && rtwo != null) {
                        rone.setReverse(rtwo);
                    }
                }
            }
        }, new Node.IncludeFilter(new Node.Field[]{AST.FILES, FileNd.OBJECT_TYPES, ObjectTypeNd.PROPERTIES, FileNd.ASSOCIATIONS}));
        this.m_errors.check();
        it = this.m_symbols.getObjectTypes().iterator();
        while (it.hasNext()) {
            ObjectTypeNd ot = (ObjectTypeNd)it.next();
            this.m_root.addObjectType(this.m_symbols.getEmitted(ot));
        }
        this.m_ast.traverse(new Node.Switch(){

            public void onObjectType(ObjectTypeNd otn) {
                ObjectMap om = new ObjectMap(PDL.this.m_symbols.getEmitted(otn));
                PDL.this.m_root.addObjectMap(om);
                PDL.this.m_symbols.setLocation(om, otn);
            }

            public void onAssociation(AssociationNd assn) {
                ObjectType ot = PDL.this.m_symbols.getEmitted(PDL.this.linkName(assn));
                if (ot != null) {
                    ObjectMap om = new ObjectMap(ot);
                    PDL.this.m_root.addObjectType(ot);
                    PDL.this.m_root.addObjectMap(om);
                    PDL.this.m_symbols.setLocation(om, assn);
                }
            }
        });
        this.emitDDL();
        this.m_errors.check();
        this.emitMapping();
        this.m_errors.check();
        this.emitEvents();
        this.m_errors.check();
        this.emitDataOperations();
        this.m_errors.check();
        this.m_ast.traverse(new Node.Switch(){

            public void onObjectType(ObjectTypeNd nd) {
                Class<?> javaClass;
                ObjectType ot = PDL.this.m_symbols.getEmitted(nd);
                JavaClassNd jcn = nd.getJavaClass();
                JavaClassNd acn = nd.getAdapterClass();
                if (jcn == null || acn == null) {
                    return;
                }
                try {
                    javaClass = Class.forName(jcn.getName());
                }
                catch (ClassNotFoundException e) {
                    PDL.this.m_errors.fatal(jcn, e.getMessage());
                    return;
                }
                ot.setJavaClass(javaClass);
                try {
                    Class<?> adapterClass = Class.forName(acn.getName());
                    Adapter ad = (Adapter)adapterClass.newInstance();
                    PDL.this.m_root.addAdapter(javaClass, ad);
                }
                catch (IllegalAccessException e) {
                    PDL.this.m_errors.fatal(acn, "illegal access: " + e.getMessage());
                }
                catch (ClassNotFoundException e) {
                    PDL.this.m_errors.fatal(acn, "class not found: " + e.getMessage());
                }
                catch (InstantiationException e) {
                    PDL.this.m_errors.fatal(acn, "instantiation exception: " + e.getMessage());
                }
            }
        });
        this.m_errors.check();
        this.m_ast.traverse(new Node.Switch(){

            public void onProperty(PropertyNd pnd) {
                Node n = pnd.getMapping();
                if (!(n instanceof ColumnNd)) {
                    return;
                }
                ObjectType ot = PDL.this.m_symbols.getEmitted(pnd.getType());
                Column col = PDL.this.lookup((ColumnNd)n);
                if (col.getType() == Integer.MIN_VALUE) {
                    Adapter ad = PDL.this.m_root.getAdapter(ot.getJavaClass());
                    col.setType(ad.defaultJDBCType());
                }
            }
        });
        this.propogateTypes();
        this.m_errors.check();
        this.m_ast.traverse(new Node.Switch(){

            public void onSuper(SuperNd sn) {
                PDL.this.m_errors.warn(sn, "super is no longer necessary and deprecated, please remove");
            }
        });
        this.m_errors.check();
    }

    public void emitVersioned() {
        VersioningMetadata.NodeSwitch nodeSwitch = VersioningMetadata.getVersioningMetadata().nodeSwitch(this.m_emitted);
        this.m_ast.traverse(nodeSwitch);
        nodeSwitch.onFinish();
    }

    private void unique(Node nd, Column[] cols, boolean primary) {
        Table table = cols[0].getTable();
        if (table.getUniqueKey(cols) != null) {
            return;
        }
        UniqueKey key = new UniqueKey(table, null, cols);
        if (primary) {
            UniqueKey pk = table.getPrimaryKey();
            if (pk != null) {
                Node prev = (Node)this.m_primaryKeys.get(pk);
                this.m_errors.warn(nd, "table already has primary key: " + prev.getLocation());
                if (prev instanceof ObjectKeyNd) {
                    return;
                }
            }
            table.setPrimaryKey(key);
            this.m_primaryKeys.put(key, nd);
            this.m_symbols.setLocation(table, nd);
        }
    }

    private void unique(Node nd, Collection ids, boolean primary) {
        final ArrayList columns = new ArrayList();
        Node.Traversal propertyToColumn = new Node.Traversal(){

            public boolean accept(Node child) {
                Node.Field f = child.getField();
                if (f == PropertyNd.MAPPING) {
                    return true;
                }
                if (f == JoinPathNd.JOINS) {
                    return child.getIndex() == 0;
                }
                return f == JoinNd.FROM;
            }

            public void onColumn(ColumnNd colnd) {
                columns.add(PDL.this.lookup(colnd));
            }
        };
        if (nd instanceof ObjectKeyNd || nd instanceof UniqueKeyNd) {
            ObjectTypeNd otn = (ObjectTypeNd)nd.getParent();
            ObjectType ot = this.m_symbols.getEmitted(otn);
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                String id = ((IdentifierNd)it.next()).getName();
                Property prop = ot.getProperty(id);
                if (prop == null) {
                    this.m_errors.warn(nd, "no such property " + id);
                    return;
                }
                PropertyNd propNd = (PropertyNd)this.getNode(prop);
                int start = columns.size();
                propNd.traverse(propertyToColumn);
                int end = columns.size();
                if (start != end) continue;
                this.m_errors.warn(nd, "no metadata for " + id);
                return;
            }
        } else if (nd instanceof PropertyNd) {
            nd.traverse(propertyToColumn);
            if (columns.size() == 0) {
                this.m_errors.warn(nd, "no metadata for " + ((PropertyNd)nd).getName().getName());
                return;
            }
        } else {
            throw new IllegalArgumentException("node type: " + nd.getClass());
        }
        if (columns.size() == 0) {
            throw new IllegalStateException("did not error out earlier");
        }
        Column[] cols = new Column[columns.size()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = (Column)columns.get(i);
        }
        this.unique(nd, cols, primary);
    }

    private void emitDDL() {
        Table table;
        final HashMap<String, Table> tables = new HashMap<String, Table>();
        Iterator<Object> it = this.m_root.getTables().iterator();
        while (it.hasNext()) {
            table = (Table)it.next();
            tables.put(table.getName(), table);
        }
        this.m_ast.traverse(new Node.Switch(){

            public void onColumn(ColumnNd colNd) {
                Table table = (Table)tables.get(colNd.getTable().getName());
                if (table == null) {
                    table = new Table(colNd.getTable().getName());
                    tables.put(table.getName(), table);
                    PDL.this.m_symbols.setLocation(table, colNd);
                }
                DbTypeNd type = colNd.getType();
                Column col = table.getColumn(colNd.getName().getName());
                if (col == null) {
                    col = new Column(colNd.getName().getName());
                    table.addColumn(col);
                    PDL.this.m_symbols.setLocation(col, colNd);
                }
                if (type != null) {
                    col.setType(type.getType());
                    col.setSize(type.getSize());
                    col.setScale(type.getScale());
                }
            }
        });
        it = tables.values().iterator();
        while (it.hasNext()) {
            table = (Table)it.next();
            if (table.getRoot() != null) continue;
            this.m_root.addTable(table);
        }
        this.m_ast.traverse(new Node.Switch(){

            public void onObjectKey(ObjectKeyNd nd) {
                PDL.this.unique(nd, nd.getProperties(), true);
            }

            public void onUniqueKey(UniqueKeyNd nd) {
                PDL.this.unique(nd, nd.getProperties(), false);
            }

            public void onReferenceKey(ReferenceKeyNd nd) {
                PDL.this.unique(nd, new Column[]{PDL.this.lookup(nd.getCol())}, true);
            }

            public void onProperty(PropertyNd nd) {
                if (nd.isUnique()) {
                    ArrayList<IdentifierNd> ids = new ArrayList<IdentifierNd>();
                    ids.add(nd.getName());
                    PDL.this.unique(nd, ids, false);
                }
            }
        }, new Node.IncludeFilter(new Node.Field[]{AST.FILES, FileNd.OBJECT_TYPES, FileNd.ASSOCIATIONS, ObjectTypeNd.OBJECT_KEY, ObjectTypeNd.UNIQUE_KEYS, ObjectTypeNd.REFERENCE_KEY, ObjectTypeNd.PROPERTIES, AssociationNd.ROLE_ONE, AssociationNd.ROLE_TWO, AssociationNd.PROPERTIES}));
        this.m_ast.traverse(new Node.Switch(){

            public void onJoinPath(JoinPathNd jpn) {
                Property prop;
                List joins = jpn.getJoins();
                if (joins.size() != 2) {
                    return;
                }
                ColumnNd from = ((JoinNd)joins.get(0)).getTo();
                ColumnNd to = ((JoinNd)joins.get(1)).getFrom();
                boolean collection = true;
                Object obj = PDL.this.getEmitted(jpn.getParent());
                if (obj != null && obj instanceof Property && !(prop = (Property)obj).isCollection()) {
                    collection = false;
                }
                if (collection) {
                    PDL.this.unique(jpn, new Column[]{PDL.this.lookup(from), PDL.this.lookup(to)}, true);
                } else {
                    PDL.this.unique(jpn, new Column[]{PDL.this.lookup(from)}, true);
                }
            }
        }, new Node.IncludeFilter(new Node.Field[]{AST.FILES, FileNd.OBJECT_TYPES, ObjectTypeNd.PROPERTIES, FileNd.ASSOCIATIONS, AssociationNd.PROPERTIES, AssociationNd.ROLE_ONE, PropertyNd.MAPPING}));
        this.m_ast.traverse(new Node.Switch(){

            public void onJoinPath(JoinPathNd jpn) {
                List joins = jpn.getJoins();
                if (joins.size() != 1) {
                    PDL.this.m_errors.fatal(jpn, "only length 1 join paths allowed here");
                    return;
                }
                JoinNd join = (JoinNd)joins.get(0);
                ColumnNd fromNd = join.getFrom();
                ColumnNd toNd = join.getTo();
                Column from = PDL.this.lookup(fromNd);
                Column to = PDL.this.lookup(toNd);
                if (from.isUniqueKey()) {
                    PDL.this.unique(toNd, new Column[]{to}, true);
                    PDL.this.fk(join, false);
                } else if (to.isUniqueKey()) {
                    PDL.this.unique(fromNd, new Column[]{from}, true);
                    PDL.this.fk(join, true);
                } else {
                    PDL.this.m_errors.fatal(jpn, "join path does not connect to a primary key");
                    return;
                }
            }
        }, new Node.IncludeFilter(new Node.Field[]{AST.FILES, FileNd.OBJECT_TYPES, ObjectTypeNd.JOIN_PATHS}));
    }

    private ObjectMap getMap(Node nd) {
        return this.m_root.getObjectMap(this.m_symbols.getEmitted((ObjectTypeNd)nd.getParent()));
    }

    private void emitMapping() {
        this.m_ast.traverse(new Node.Switch(){

            public void onIdentifier(IdentifierNd id) {
                ObjectTypeNd ot = (ObjectTypeNd)id.getParent().getParent();
                ObjectMap om = PDL.this.m_root.getObjectMap(PDL.this.m_symbols.getEmitted(ot));
                Role role = (Role)PDL.this.m_symbols.getEmitted(ot).getProperty(id.getName());
                if (role == null) {
                    PDL.this.m_errors.fatal(id, "no such property: " + id.getName());
                } else if (role.isCollection()) {
                    PDL.this.m_errors.fatal(id, "collections cannot be keys: " + id.getName());
                } else {
                    om.getKeyProperties().add(role);
                    role.setNullable(false);
                }
            }
        }, new Node.IncludeFilter(new Node.Field[]{AST.FILES, FileNd.OBJECT_TYPES, ObjectTypeNd.OBJECT_KEY, ObjectKeyNd.PROPERTIES}));
        this.m_ast.traverse(new Node.Switch(){

            public void onAssociation(AssociationNd assn) {
                if (assn.getProperties().size() == 0) {
                    return;
                }
                PropertyNd one = assn.getRoleOne();
                PropertyNd two = assn.getRoleTwo();
                ObjectType ot = PDL.this.m_symbols.getEmitted(PDL.this.linkName(assn));
                ObjectMap om = PDL.this.m_root.getObjectMap(ot);
                List keys = om.getKeyProperties();
                Role pone = (Role)ot.getProperty(one.getName().getName());
                Role ptwo = (Role)ot.getProperty(two.getName().getName());
                Link lone = (Link)ptwo.getType().getProperty(pone.getName());
                Link ltwo = (Link)pone.getType().getProperty(ptwo.getName());
                keys.add(ptwo);
                keys.add(pone);
                if (one.getMapping() != null) {
                    PDL.this.emitMapping(pone, (JoinPathNd)one.getMapping(), 1, 2);
                    PDL.this.emitMapping(pone.getReverse(), (JoinPathNd)two.getMapping(), 0, 1);
                    PDL.this.emitMapping(ltwo, (JoinPathNd)two.getMapping(), 0, 2);
                } else {
                    om.addMapping(new Static(Path.get(pone.getName())));
                    ObjectMap oneom = PDL.this.m_root.getObjectMap(pone.getType());
                    oneom.addMapping(new Static(Path.get(pone.getReverse().getName())));
                    oneom.addMapping(new Static(Path.get(ltwo.getName())));
                }
                if (two.getMapping() != null) {
                    PDL.this.emitMapping(ptwo, (JoinPathNd)two.getMapping(), 1, 2);
                    PDL.this.emitMapping(ptwo.getReverse(), (JoinPathNd)one.getMapping(), 0, 1);
                    PDL.this.emitMapping(lone, (JoinPathNd)one.getMapping(), 0, 2);
                } else {
                    om.addMapping(new Static(Path.get(ptwo.getName())));
                    ObjectMap twoom = PDL.this.m_root.getObjectMap(ptwo.getType());
                    twoom.addMapping(new Static(Path.get(ptwo.getReverse().getName())));
                    twoom.addMapping(new Static(Path.get(lone.getName())));
                }
                String[] paths = new String[]{pone.getName(), ptwo.getName()};
                for (int i = 0; i < paths.length; ++i) {
                    Mapping m = om.getMapping(Path.get(paths[i]));
                    if (m.getTable() == null) continue;
                    om.setTable(m.getTable());
                    break;
                }
            }
        });
        this.m_ast.traverse(new Node.Switch(){

            public void onProperty(PropertyNd pn) {
                Role prop = (Role)PDL.this.getEmitted(pn);
                if (prop == null) {
                    return;
                }
                ObjectMap om = PDL.this.m_root.getObjectMap(prop.getContainer());
                Node mapping = pn.getMapping();
                if (mapping == null) {
                    om.addMapping(new Static(Path.get(prop.getName())));
                } else if (mapping instanceof ColumnNd) {
                    PDL.this.emitMapping(prop, (ColumnNd)mapping);
                } else if (mapping instanceof JoinPathNd) {
                    PDL.this.emitMapping(prop, (JoinPathNd)mapping);
                } else {
                    PDL.this.emitMapping(prop, (QualiasNd)mapping);
                }
                if (pn.isComposite() && pn.getParent() instanceof ObjectTypeNd) {
                    if (mapping == null) {
                        PDL.this.m_errors.fatal(pn, "one-way composite must have metadata");
                    } else {
                        Role rev = prop.getReverse();
                        if (mapping instanceof JoinPathNd) {
                            PDL.this.emitMapping(rev, (JoinPathNd)mapping, true);
                        } else {
                            PDL.this.m_errors.fatal(pn, "must have a join path");
                        }
                    }
                }
            }
        });
        this.m_ast.traverse(new Node.Switch(){

            public void onReferenceKey(ReferenceKeyNd rkn) {
                Column key = PDL.this.lookup(rkn.getCol());
                ObjectMap om = PDL.this.getMap(rkn);
                om.setTable(key.getTable());
            }

            public void onObjectKey(ObjectKeyNd okn) {
                IdentifierNd prop;
                ObjectMap om = PDL.this.getMap(okn);
                Mapping m = om.getMapping(Path.get((prop = (IdentifierNd)okn.getProperties().iterator().next()).getName()));
                if (m != null) {
                    om.setTable(m.getTable());
                }
            }
        });
        this.m_ast.traverse(new Node.Switch(){

            public void onReferenceKey(ReferenceKeyNd rkn) {
                Column key = PDL.this.lookup(rkn.getCol());
                ObjectMap om = PDL.this.getMap(rkn);
                Column[] cols = new Column[]{key};
                if (key.getTable().getForeignKey(cols) == null) {
                    Table table = null;
                    for (ObjectMap sm = om.getSuperMap(); sm != null && (table = sm.getTable()) == null; sm = sm.getSuperMap()) {
                    }
                    if (table == null) {
                        throw new IllegalStateException("unable to find supertable for " + om.getObjectType());
                    }
                    PDL.this.fk(cols, table.getPrimaryKey());
                }
            }
        });
        this.m_ast.traverse(new Node.Switch(){

            public void onPath(PathNd nd) {
                ObjectMap om = PDL.this.m_root.getObjectMap(PDL.this.m_symbols.getEmitted((ObjectTypeNd)nd.getParent().getParent()));
                om.addFetchedPath(nd.getPath());
            }
        }, new Node.IncludeFilter(new Node.Field[]{AST.FILES, FileNd.OBJECT_TYPES, ObjectTypeNd.AGGRESSIVE_LOAD, AggressiveLoadNd.PATHS}));
    }

    private void propogateTypes() {
        int before;
        do {
            before = this.m_fks.size();
            Iterator it = this.m_fks.iterator();
            while (it.hasNext()) {
                ForeignKey fk = (ForeignKey)it.next();
                Column[] cols = fk.getColumns();
                Column[] to = fk.getUniqueKey().getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    if (cols[i].getType() != Integer.MIN_VALUE || to[i].getType() == Integer.MIN_VALUE) continue;
                    cols[i].setType(to[i].getType());
                    cols[i].setSize(to[i].getSize());
                    cols[i].setScale(to[i].getScale());
                    it.remove();
                }
            }
        } while (this.m_fks.size() < before);
    }

    private void emitMapping(Property prop, ColumnNd colNd) {
        Column col;
        Property prev;
        if (prop.getType().isKeyed()) {
            this.m_errors.fatal(colNd, "association requires a join path");
        }
        if ((prev = (Property)this.m_propByColumns.get(col = this.lookup(colNd))) == null) {
            this.m_propByColumns.put(col, prop);
        } else {
            ObjectType ot2;
            ObjectType ot1 = prop.getContainer();
            if ((ot1.isSubtypeOf(ot2 = prev.getContainer()) || ot2.isSubtypeOf(ot1)) && !prop.equals(prev)) {
                this.m_errors.fatal(colNd, "column already mapped to " + prev);
            }
        }
        ObjectMap om = this.m_root.getObjectMap(prop.getContainer());
        Value m = new Value(Path.get(prop.getName()), col);
        om.addMapping(m);
        if (prop.isNullable()) {
            col.setNullable(true);
        }
    }

    private ForeignKey fk(JoinNd jn, boolean forward) {
        ColumnNd tond;
        ColumnNd fromnd;
        if (forward) {
            fromnd = jn.getFrom();
            tond = jn.getTo();
        } else {
            fromnd = jn.getTo();
            tond = jn.getFrom();
        }
        Column from = this.lookup(fromnd);
        Column to = this.lookup(tond);
        ForeignKey fk = from.getTable().getForeignKey(new Column[]{from});
        UniqueKey uk = to.getTable().getUniqueKey(new Column[]{to});
        if (uk == null) {
            this.m_errors.fatal(tond, "not a unique key: " + to);
            return null;
        }
        if (fk != null) {
            if (uk.equals(fk.getUniqueKey())) {
                return fk;
            }
            Node prev = this.getNode(fk);
            this.m_errors.fatal(fromnd, "foreign key incompatible with previous definition: " + prev.getLocation());
            return null;
        }
        fk = this.fk(new Column[]{from}, uk);
        this.emit(fromnd, fk);
        return fk;
    }

    private ForeignKey fk(Column[] cols, UniqueKey uk) {
        Column[] to = uk.getColumns();
        if (cols.length != to.length) {
            throw new IllegalArgumentException("foreign key length must match unique key length");
        }
        ForeignKey fk = new ForeignKey(cols[0].getTable(), null, cols, uk, false);
        this.m_fks.add(fk);
        return fk;
    }

    private void emitMapping(Role prop, JoinPathNd jpn) {
        this.emitMapping(prop, jpn, false);
    }

    private void emitMapping(Role prop, JoinPathNd jpn, boolean reverse) {
        if (reverse) {
            this.emitMapping(prop, jpn, jpn.getJoins().size(), 0);
        } else {
            this.emitMapping(prop, jpn, 0, jpn.getJoins().size());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void emitMapping(Property prop, JoinPathNd jpn, int start, int stop) {
        void var8_20;
        Mapping m;
        int low;
        if (!prop.getType().isKeyed()) {
            this.m_errors.fatal(jpn, "cannot associate to a non keyed type");
        }
        ObjectMap om = this.m_root.getObjectMap(prop.getContainer());
        Path path = Path.get(prop.getName());
        List joins = jpn.getJoins();
        int magnitude = Math.abs(stop - start);
        boolean forward = stop > start;
        int n = low = forward ? start : stop;
        if (magnitude == 1) {
            void var12_17;
            boolean joinForward;
            JoinNd jn = (JoinNd)joins.get(low);
            Column to = this.lookup(jn.getTo());
            Column from = this.lookup(jn.getFrom());
            if (to.isPrimaryKey()) {
                joinForward = true;
            } else if (from.isPrimaryKey()) {
                joinForward = false;
            } else if (to.isUniqueKey()) {
                joinForward = true;
            } else if (from.isUniqueKey()) {
                joinForward = false;
            } else {
                this.m_errors.fatal(jpn, "neither end unique");
                return;
            }
            ForeignKey fk = this.fk(jn, (boolean)var12_17);
            if (fk == null) {
                return;
            }
            if (forward == var12_17) {
                m = new JoinTo(path, fk);
                this.setNullable(fk, prop.isNullable());
            } else {
                m = new JoinFrom(path, fk);
                if (!((Role)prop).isReversable()) {
                    this.setNullable(fk, prop.isNullable());
                }
            }
        } else if (magnitude == 2) {
            JoinNd first = (JoinNd)joins.get(low);
            JoinNd second = (JoinNd)joins.get(low + 1);
            ForeignKey from = this.fk(first, !forward);
            ForeignKey to = this.fk(second, forward);
            if (from == null || to == null) {
                return;
            }
            m = forward ? new JoinThrough(path, from, to) : new JoinThrough(path, to, from);
            if (prop instanceof Role) {
                this.setNullable(from, false);
                this.setNullable(to, false);
            }
        } else {
            this.m_errors.fatal(jpn, "bad join path");
            return;
        }
        om.addMapping((Mapping)var8_20);
    }

    private void setNullable(Constraint c, boolean value) {
        if (value) {
            Column[] cols = c.getColumns();
            for (int i = 0; i < cols.length; ++i) {
                cols[i].setNullable(true);
            }
        }
    }

    private Column lookup(ColumnNd colNd) {
        Table table = this.m_root.getTable(colNd.getTable().getName());
        return table.getColumn(colNd.getName().getName());
    }

    private void emitMapping(Property prop, QualiasNd nd) {
        ObjectMap om = this.m_root.getObjectMap(prop.getContainer());
        Qualias q = new Qualias(Path.get(prop.getName()), nd.getQuery());
        om.addMapping(q);
    }

    private void emitEvents() {
        this.m_ast.traverse(new Node.Switch(){

            public void onEvent(EventNd nd) {
                PDL.this.emitEvent(nd);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void emitEvent(EventNd ev) {
        void var5_7;
        void var4_6;
        void var3_5;
        String name;
        EventNd.Type type;
        ObjectType ot;
        String givenName = null;
        if (ev.getName() != null) {
            givenName = ev.getName().getName();
        }
        if (ev.getParent() instanceof ObjectTypeNd) {
            ObjectTypeNd otn = (ObjectTypeNd)ev.getParent();
            ot = this.m_symbols.getEmitted(otn);
            type = ev.getType();
            name = givenName;
        } else {
            AssociationNd assn = (AssociationNd)ev.getParent();
            String one = assn.getRoleOne().getName().getName();
            String two = assn.getRoleTwo().getName().getName();
            ObjectType oneType = this.m_symbols.getEmitted(assn.getRoleOne().getType());
            ObjectType twoType = this.m_symbols.getEmitted(assn.getRoleTwo().getType());
            if (assn.getProperties().size() > 0) {
                Collection blocks;
                ot = this.m_symbols.getEmitted(this.linkName(assn));
                boolean warnDups = true;
                if ((givenName == null || givenName.equals(one) || givenName.equals(two)) && ev.getType().equals(EventNd.ADD)) {
                    type = EventNd.INSERT;
                    name = null;
                } else if ((givenName == null || givenName.equals(one) || givenName.equals(two)) && ev.getType().equals(EventNd.REMOVE)) {
                    type = EventNd.DELETE;
                    name = null;
                } else {
                    type = ev.getType();
                    name = givenName;
                    warnDups = false;
                }
                if (warnDups && (blocks = this.getSQLBlocks(ot, type, name)) != null && blocks.size() > 0) {
                    this.m_errors.warn(ev, "redundant events specified, ignoring this event");
                    return;
                }
            } else if (givenName == null || givenName.equals(one)) {
                Collection blocks;
                if (givenName != null && !ev.isSingle() && (blocks = this.getSQLBlocks(oneType, ev.getType(), two)) != null && blocks.size() > 0) {
                    this.m_errors.warn(ev, "both ends of a two way specified, ignoring this event");
                    return;
                }
                ot = twoType;
                type = ev.getType();
                name = one;
            } else if (givenName.equals(two)) {
                Collection blocks;
                if (!ev.isSingle() && (blocks = this.getSQLBlocks(twoType, ev.getType(), one)) != null && blocks.size() > 0) {
                    this.m_errors.warn(ev, "both ends of a two way specified, ignoring this event");
                    return;
                }
                ot = oneType;
                type = ev.getType();
                name = two;
            } else {
                this.m_errors.warn(ev.getName(), "no such role: " + ev.getName().getName());
                return;
            }
        }
        this.addEvent(this.m_root.getObjectMap((ObjectType)var3_5), ev, (EventNd.Type)var4_6, (String)var5_7);
    }

    private Collection getSQLBlocks(ObjectType ot, EventNd.Type type, String role) {
        return this.getSQLBlocks(ot.getRoot().getObjectMap(ot), type, role);
    }

    private void setSQLBlocks(ObjectType ot, EventNd nd, EventNd.Type type, String role, Collection blocks) {
        this.setSQLBlocks(ot.getRoot().getObjectMap(ot), nd, type, role, blocks);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection getSQLBlocks(ObjectMap om, EventNd.Type type, String role) {
        void var4_4;
        ArrayList blocks;
        if (type.equals(EventNd.INSERT)) {
            blocks = om.getDeclaredInserts();
            return var4_4;
        } else if (type.equals(EventNd.UPDATE)) {
            blocks = om.getDeclaredUpdates();
            return var4_4;
        } else if (type.equals(EventNd.DELETE)) {
            blocks = om.getDeclaredDeletes();
            return var4_4;
        } else if (type.equals(EventNd.RETRIEVE)) {
            if (role != null) throw new Error("single block event");
            blocks = om.getDeclaredRetrieves();
            return var4_4;
        } else if (type.equals(EventNd.ADD)) {
            blocks = this.getMapping(om, role).getAdds();
            return var4_4;
        } else if (type.equals(EventNd.REMOVE)) {
            blocks = this.getMapping(om, role).getRemoves();
            return var4_4;
        } else if (type.equals(EventNd.CLEAR)) {
            blocks = new ArrayList();
            return var4_4;
        } else {
            if (!type.equals(EventNd.RETRIEVE_ATTRIBUTES)) throw new IllegalArgumentException("bad event type: " + type);
            blocks = new ArrayList();
        }
        return var4_4;
    }

    private static Collection add(Collection a, Collection b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList result = new ArrayList();
        result.addAll(a);
        result.addAll(b);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setSQLBlocks(ObjectMap om, EventNd nd, EventNd.Type type, String role, Collection blocks) {
        if (type.equals(EventNd.INSERT)) {
            if (!this.checkDuplicates(om, om.getDeclaredInserts(), blocks, nd)) return;
            om.setDeclaredInserts(blocks);
            return;
        } else if (type.equals(EventNd.UPDATE)) {
            if (!this.checkDuplicates(om, om.getDeclaredUpdates(), blocks, nd)) return;
            om.setDeclaredUpdates(blocks);
            return;
        } else if (type.equals(EventNd.DELETE)) {
            if (!this.checkDuplicates(om, om.getDeclaredDeletes(), blocks, nd)) return;
            om.setDeclaredDeletes(blocks);
            return;
        } else if (type.equals(EventNd.RETRIEVE)) {
            if (role != null) throw new Error("single block event");
            om.setDeclaredRetrieves(PDL.add(blocks, om.getDeclaredRetrieves()));
            return;
        } else if (type.equals(EventNd.ADD)) {
            Mapping m = this.getMapping(om, role);
            if (!this.checkDuplicates(om, m.getAdds(), blocks, nd)) return;
            m.setAdds(blocks);
            return;
        } else if (type.equals(EventNd.REMOVE)) {
            Mapping m = this.getMapping(om, role);
            if (!this.checkDuplicates(om, m.getRemoves(), blocks, nd)) return;
            m.setRemoves(blocks);
            return;
        } else {
            if (type.equals(EventNd.CLEAR)) return;
            if (!type.equals(EventNd.RETRIEVE_ATTRIBUTES)) throw new IllegalArgumentException("bad event type: " + type);
            om.setDeclaredRetrieves(PDL.add(om.getDeclaredRetrieves(), blocks));
        }
    }

    private boolean checkDuplicates(ObjectMap om, Object prev, Object obj, EventNd nd) {
        if (prev != null) {
            Node prevNd = this.getNode(prev);
            this.m_errors.fatal(nd, "duplicate " + nd.getType() + " event for object type " + om.getObjectType().getQualifiedName() + ", previous definition: " + prevNd.getLocation());
            return false;
        }
        this.emit(nd, obj);
        return true;
    }

    private void addEvent(ObjectMap om, EventNd ev, EventNd.Type type, String role) {
        if (type.equals(EventNd.RETRIEVE) && role != null) {
            Mapping m = this.getMapping(om, role);
            SQLBlock block = this.getBlock(om, ev);
            if (this.checkDuplicates(om, m.getRetrieve(), block, ev)) {
                m.setRetrieve(block);
            }
            return;
        }
        if (type.equals(EventNd.RETRIEVE_ALL)) {
            SQLBlock block = this.getBlock(om, ev);
            if (this.checkDuplicates(om, om.getRetrieveAll(), block, ev)) {
                om.setRetrieveAll(block);
            }
            return;
        }
        ArrayList<SQLBlock> blocks = new ArrayList<SQLBlock>();
        Iterator it = ev.getSQL().iterator();
        while (it.hasNext()) {
            SQLBlockNd nd = (SQLBlockNd)it.next();
            blocks.add(this.getBlock(om, nd));
        }
        this.setSQLBlocks(om, ev, type, role, blocks);
    }

    private SQLBlock getBlock(ObjectMap om, EventNd ev) {
        Iterator it;
        if (ev.getSQL().size() > 1) {
            this.m_errors.fatal(ev, "more than one sql block");
        }
        if ((it = ev.getSQL().iterator()).hasNext()) {
            return this.getBlock(om, (SQLBlockNd)it.next());
        }
        return null;
    }

    private SQLBlock getBlock(ObjectMap om, SQLBlockNd nd) {
        final ObjectType type = om == null ? null : om.getObjectType();
        try {
            SQLParser p = new SQLParser(new StringReader(nd.getSQL()));
            p.sql();
            final SQLBlock block = new SQLBlock(p.getSQL());
            this.m_symbols.setLocation(block, nd);
            Iterator ii = p.getAssigns().iterator();
            while (ii.hasNext()) {
                SQLParser.Assign assn = (SQLParser.Assign)ii.next();
                block.addAssign(assn.getBegin(), assn.getEnd().getNext());
            }
            nd.traverse(new Node.Switch(){

                private void checkPath(Node nd, Path path) {
                    if (type != null && !type.exists(path)) {
                        PDL.this.m_errors.fatal(nd, "no such path in " + type.getQualifiedName() + ": " + path);
                    }
                }

                public void onMapping(MappingNd nd) {
                    Path col = nd.getCol().getPath();
                    col = Path.get(col.getName());
                    Path path = nd.getPath().getPath();
                    this.checkPath(nd, path);
                    block.addMapping(path, col);
                }

                public void onBinding(BindingNd nd) {
                    Path path = nd.getPath().getPath();
                    this.checkPath(nd, path);
                    block.addType(path, nd.getType().getType());
                }
            });
            return block;
        }
        catch (com.redhat.persistence.common.ParseException e) {
            this.m_errors.fatal(nd, e.getMessage());
            return null;
        }
    }

    private Mapping getMapping(ObjectMap om, String role) {
        Path path = Path.get(role);
        Mapping m = om.getMapping(path);
        if (m == null) {
            throw new IllegalStateException("no mapping in type " + om.getObjectType() + " for role: " + role);
        }
        return m;
    }

    private void emitDataOperations() {
        this.m_ast.traverse(new Node.Switch(){

            public void onDataOperation(DataOperationNd nd) {
                Path name = Path.get(nd.getFile().getModel().getName() + "." + nd.getName().getName());
                PDL.this.m_root.addDataOperation(new DataOperation(name, PDL.this.getBlock(null, nd.getSQL())));
            }
        });
    }

    public static final void main(String[] args) throws Exception {
        PDL pdl = new PDL();
        for (int i = 0; i < args.length; ++i) {
            pdl.load(new FileReader(args[i]), args[i]);
        }
        Root root = new Root();
        pdl.emit(root);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

