/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.common.CompoundKey;
import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.Constraint;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.metadata.UniqueKey;
import com.redhat.persistence.oql.Generator;
import com.redhat.persistence.oql.MultiMap;
import com.redhat.persistence.oql.QFrame;
import com.redhat.persistence.oql.QValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.list.SetUniqueList;
import org.apache.log4j.Logger;

class EquiSet {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/EquiSet.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$redhat$persistence$oql$EquiSet == null ? (class$com$redhat$persistence$oql$EquiSet = EquiSet.class$("com.redhat.persistence.oql.EquiSet")) : class$com$redhat$persistence$oql$EquiSet));
    private Generator m_generator;
    private Map m_nodes = new HashMap();
    private List m_partitions = new ArrayList();
    private List m_free = new ArrayList();
    private List m_frames = SetUniqueList.decorate(new ArrayList());
    private List m_framesets = new ArrayList();
    private List m_equals = new ArrayList();
    private MultiMap m_collated = new MultiMap();
    private MultiMap m_columns = new MultiMap();
    private List m_keys = new ArrayList();
    private List m_from = SetUniqueList.decorate(new ArrayList());
    static /* synthetic */ Class class$com$redhat$persistence$oql$EquiSet;

    EquiSet(Generator generator) {
        this.m_generator = generator;
    }

    int size() {
        return this.m_nodes.size();
    }

    void clear() {
        this.m_nodes.clear();
        this.m_free.clear();
        for (int i = 0; i < this.m_partitions.size(); ++i) {
            this.getPartition(i).clear();
            this.m_free.add(new Integer(i));
        }
        this.m_frames.clear();
        this.m_framesets.clear();
    }

    boolean isEmpty() {
        return this.m_nodes.isEmpty();
    }

    List get(Object nd) {
        Integer idx = (Integer)this.m_nodes.get(nd);
        if (idx == null) {
            return null;
        }
        return this.getPartition(idx);
    }

    Integer partition(Object nd) {
        return (Integer)this.m_nodes.get(nd);
    }

    List getPartitions() {
        return this.m_partitions;
    }

    List getPartition(Integer idx) {
        return this.getPartition((int)idx);
    }

    List getPartition(int i) {
        return (List)this.m_partitions.get(i);
    }

    private int allocatePartition() {
        int result;
        if (this.m_free.isEmpty()) {
            result = this.m_partitions.size();
            this.m_partitions.add(new ArrayList());
        } else {
            result = (Integer)this.m_free.remove(this.m_free.size() - 1);
        }
        return result;
    }

    boolean equate(QValue a, QValue b) {
        this.m_frames.add(a.getFrame());
        this.m_frames.add(b.getFrame());
        this.m_equals.clear();
        this.m_equals.add(a);
        if (!a.equals(b)) {
            this.m_equals.add(b);
        }
        return this.add(this.m_equals);
    }

    boolean equate(Object a, Object b) {
        this.m_equals.clear();
        this.m_equals.add(a);
        if (!a.equals(b)) {
            this.m_equals.add(b);
        }
        return this.add(this.m_equals);
    }

    void collapse() {
        while (this.doCollapse()) {
        }
    }

    private boolean doCollapse() {
        int i;
        Object key;
        this.m_collated.clear();
        this.m_columns.clear();
        for (int i2 = 0; i2 < this.m_frames.size(); ++i2) {
            QFrame frame = (QFrame)this.m_frames.get(i2);
            this.m_keys.clear();
            this.keys(frame, this.m_keys);
            for (int j = 0; j < this.m_keys.size(); ++j) {
                key = this.m_keys.get(j);
                this.m_collated.add(key, frame);
                this.m_columns.addAll(key, frame.getColumns());
            }
        }
        boolean modified = false;
        List keys = this.m_collated.keys();
        for (i = 0; i < keys.size(); ++i) {
            key = keys.get(i);
            List frames = this.m_collated.get(key);
            List cols = this.m_columns.get(key);
            for (int j = 0; j < cols.size(); ++j) {
                String col = (String)cols.get(j);
                this.m_equals.clear();
                for (int k = 0; k < frames.size(); ++k) {
                    QFrame frame = (QFrame)frames.get(k);
                    this.m_equals.add(frame.getValue(col));
                }
                modified |= this.add(this.m_equals);
            }
        }
        if (!modified) {
            this.m_framesets.clear();
            for (i = 0; i < keys.size(); ++i) {
                this.m_framesets.add(this.m_collated.get(keys.get(i)));
            }
        }
        return modified;
    }

    void keys(QFrame frame, List result) {
        Table t = this.m_generator.getRoot().getTable(frame.getTable());
        if (t == null) {
            return;
        }
        Iterator it = t.getConstraints().iterator();
        block0: while (it.hasNext()) {
            Constraint c = (Constraint)it.next();
            if (!(c instanceof UniqueKey)) continue;
            UniqueKey uk = (UniqueKey)c;
            Column[] cols = uk.getColumns();
            Object key = uk;
            for (int i = 0; i < cols.length; ++i) {
                if (!frame.hasValue(cols[i].getName())) continue block0;
                QValue v = frame.getValue(cols[i].getName());
                Object id = this.m_nodes.get(v);
                if (id == null) {
                    id = v;
                }
                key = key == null ? id : new CompoundKey(id, key);
            }
            result.add(key);
        }
    }

    List getFrameSets() {
        return this.m_framesets;
    }

    boolean add(List equal) {
        Integer to = null;
        List added = null;
        int addedidx = -1;
        this.m_from.clear();
        for (int i = 0; i < equal.size(); ++i) {
            Object o = equal.get(i);
            Integer idx = (Integer)this.m_nodes.get(o);
            if (idx == null) {
                if (added == null) {
                    addedidx = this.allocatePartition();
                    added = this.getPartition(addedidx);
                }
                added.add(o);
                continue;
            }
            if (to == null) {
                to = idx;
                continue;
            }
            if (to.equals(idx)) continue;
            List top = this.getPartition(to);
            List fromp = this.getPartition(idx);
            if (fromp.size() > top.size()) {
                this.m_from.add(to);
                to = idx;
                continue;
            }
            this.m_from.add(idx);
        }
        if (to == null) {
            if (added == null) {
                return false;
            }
            this.partitionAll(added, new Integer(addedidx));
            return true;
        }
        List top = this.getPartition(to);
        boolean modified = false;
        if (added != null) {
            if (added.size() > top.size()) {
                this.m_from.add(to);
                to = new Integer(addedidx);
                top = added;
                this.partitionAll(added, to);
                modified = true;
            } else {
                this.m_from.add(new Integer(addedidx));
            }
        }
        for (int i = 0; i < this.m_from.size(); ++i) {
            Integer idx = (Integer)this.m_from.get(i);
            List from = this.getPartition(idx);
            for (int j = 0; j < from.size(); ++j) {
                Object o = from.get(j);
                top.add(o);
                this.m_nodes.put(o, to);
            }
            from.clear();
            this.m_free.add(idx);
            modified = true;
        }
        return modified;
    }

    private void partitionAll(List p, Integer idx) {
        for (int i = 0; i < p.size(); ++i) {
            this.m_nodes.put(p.get(i), idx);
        }
    }

    boolean addAll(EquiSet equiset) {
        boolean modified = false;
        for (int i = 0; i < equiset.m_partitions.size(); ++i) {
            List p = equiset.getPartition(i);
            if (p.isEmpty()) continue;
            modified |= this.add(p);
        }
        this.m_frames.addAll(equiset.m_frames);
        return modified;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        boolean first = true;
        for (int i = 0; i < this.m_partitions.size(); ++i) {
            List p = this.getPartition(i);
            if (p.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                buf.append(" | ");
            }
            for (int j = 0; j < p.size(); ++j) {
                buf.append(p.get(j));
                if (j >= p.size() - 1) continue;
                buf.append(", ");
            }
        }
        buf.append("}");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

