/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.metadata;

import com.redhat.persistence.common.Path;
import com.redhat.persistence.metadata.Element;
import com.redhat.persistence.metadata.JoinFrom;
import com.redhat.persistence.metadata.JoinThrough;
import com.redhat.persistence.metadata.JoinTo;
import com.redhat.persistence.metadata.Mapping;
import com.redhat.persistence.metadata.Mist;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Qualias;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.metadata.SQLBlock;
import com.redhat.persistence.metadata.Static;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.metadata.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ObjectMap
extends Element {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/metadata/ObjectMap.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ObjectType m_type;
    private Mist m_mappings = new Mist(this);
    private ArrayList m_key = new ArrayList();
    private ArrayList m_fetched = new ArrayList();
    private Table m_table;
    private SQLBlock m_retrieveAll;
    private ArrayList m_retrieves = null;
    private ArrayList m_inserts = null;
    private ArrayList m_updates = null;
    private ArrayList m_deletes = null;

    public ObjectMap(ObjectType type) {
        this.m_type = type;
    }

    public Root getRoot() {
        return (Root)this.getParent();
    }

    public ObjectMap getSuperMap() {
        if (this.m_type.getSupertype() == null) {
            return null;
        }
        return this.getRoot().getObjectMap(this.m_type.getSupertype());
    }

    public ObjectType getObjectType() {
        return this.m_type;
    }

    public boolean hasMapping(Path p) {
        if (this.m_mappings.containsKey(p)) {
            return true;
        }
        ObjectMap sm = this.getSuperMap();
        if (sm == null) {
            return false;
        }
        return sm.hasMapping(p);
    }

    public Mapping getMapping(Path p) {
        if (this.m_mappings.containsKey(p)) {
            return (Mapping)this.m_mappings.get(p);
        }
        ObjectMap sm = this.getSuperMap();
        if (sm == null) {
            return null;
        }
        return sm.getMapping(p);
    }

    public void addMapping(Mapping mapping) {
        this.m_mappings.add(mapping);
    }

    private void getMappings(ArrayList result) {
        ObjectMap sm = this.getSuperMap();
        if (sm != null) {
            sm.getMappings(result);
        }
        result.addAll(this.m_mappings);
    }

    public Collection getMappings() {
        ArrayList result = new ArrayList();
        this.getMappings(result);
        return result;
    }

    public Collection getDeclaredMappings() {
        ArrayList result = new ArrayList();
        result.addAll(this.m_mappings);
        return result;
    }

    public List getKeyProperties() {
        ObjectMap sm = this.getSuperMap();
        if (sm == null) {
            return this.m_key;
        }
        return sm.getKeyProperties();
    }

    public Collection getFetchedPaths() {
        ObjectMap sm = this.getSuperMap();
        if (sm == null) {
            return this.getDeclaredFetchedPaths();
        }
        Collection result = sm.getFetchedPaths();
        result.addAll(this.getDeclaredFetchedPaths());
        return result;
    }

    public Collection getDeclaredFetchedPaths() {
        SQLBlock sql;
        final ArrayList result = new ArrayList();
        Iterator it = this.getDeclaredMappings().iterator();
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            m.dispatch(new Mapping.Switch(){

                public void onValue(Value m) {
                    if (!result.contains(m.getPath())) {
                        result.add(m.getPath());
                    }
                }

                public void onJoinTo(JoinTo m) {
                }

                public void onJoinFrom(JoinFrom m) {
                }

                public void onJoinThrough(JoinThrough m) {
                }

                public void onStatic(Static m) {
                }

                public void onQualias(Qualias q) {
                }
            });
        }
        it = this.m_fetched.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (result.contains(o)) continue;
            result.add(o);
        }
        if (result.size() == 0 && (sql = this.getRetrieveAll()) != null) {
            Iterator it2 = sql.getPaths().iterator();
            while (it2.hasNext()) {
                Object o = it2.next();
                if (result.contains(o)) continue;
                result.add(o);
            }
        }
        return result;
    }

    public void addFetchedPath(Path p) {
        if (!this.m_fetched.contains(p)) {
            this.m_fetched.add(p);
        }
    }

    public Table getTable() {
        return this.m_table;
    }

    public void setTable(Table table) {
        this.m_table = table;
    }

    public Collection getDeclaredTables() {
        if (this.m_table == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Table> result = new ArrayList<Table>(1);
        result.add(this.m_table);
        return result;
    }

    public Collection getTables() {
        return this.getTables(this.getObjectType().getProperties());
    }

    private Collection getTables(Collection properties) {
        ArrayList<Table> result = new ArrayList<Table>();
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            Mapping m = this.getMapping(Path.get(prop.getName()));
            Table t = m.getTable();
            if (t == null || result.contains(t)) continue;
            result.add(t);
        }
        return result;
    }

    public SQLBlock getRetrieveAll() {
        return this.m_retrieveAll;
    }

    public void setRetrieveAll(SQLBlock retrieveAll) {
        this.m_retrieveAll = retrieveAll;
    }

    public Collection getDeclaredRetrieves() {
        return this.m_retrieves;
    }

    public void setDeclaredRetrieves(Collection retrieves) {
        if (retrieves == null) {
            this.m_retrieves = null;
        } else {
            this.m_retrieves = new ArrayList();
            this.m_retrieves.addAll(retrieves);
        }
    }

    public Collection getRetrieves() {
        if (this.getSuperMap() == null) {
            ArrayList result = new ArrayList();
            if (this.m_retrieves != null) {
                result.addAll(this.m_retrieves);
            }
            return result;
        }
        Collection result = this.getSuperMap().getRetrieves();
        if (this.m_retrieves != null) {
            result.addAll(this.m_retrieves);
        }
        return result;
    }

    public Collection getDeclaredInserts() {
        return this.m_inserts;
    }

    public void setDeclaredInserts(Collection inserts) {
        if (inserts == null) {
            this.m_inserts = null;
        } else {
            this.m_inserts = new ArrayList();
            this.m_inserts.addAll(inserts);
        }
    }

    public Collection getDeclaredUpdates() {
        return this.m_updates;
    }

    public void setDeclaredUpdates(Collection updates) {
        if (updates == null) {
            this.m_updates = null;
        } else {
            this.m_updates = new ArrayList();
            this.m_updates.addAll(updates);
        }
    }

    public Collection getUpdates() {
        if (this.getSuperMap() == null) {
            ArrayList result = new ArrayList();
            if (this.m_updates != null) {
                result.addAll(this.m_updates);
            }
            return result;
        }
        Collection result = this.getSuperMap().getUpdates();
        if (this.m_updates != null) {
            result.addAll(this.m_updates);
        }
        return result;
    }

    public Collection getDeclaredDeletes() {
        return this.m_deletes;
    }

    public void setDeclaredDeletes(Collection deletes) {
        if (deletes == null) {
            this.m_deletes = null;
        } else {
            this.m_deletes = new ArrayList();
            this.m_deletes.addAll(deletes);
        }
    }

    Object getElementKey() {
        return this.getObjectType();
    }

    public String toString() {
        return "object map for " + this.m_type + " mappings: " + this.m_mappings;
    }
}

