/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.metadata;

import com.redhat.persistence.metadata.Element;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;

class Mist
extends AbstractList {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/metadata/Mist.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Object m_parent = null;
    private ArrayList m_children = new ArrayList();
    private HashMap m_childrenMap = new HashMap();

    public Mist(Object parent) {
        this.m_parent = parent;
    }

    private Object check(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("null child");
        }
        if (!(o instanceof Element)) {
            throw new IllegalArgumentException("not an element");
        }
        Element child = (Element)o;
        Object key = child.getElementKey();
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        return key;
    }

    public void add(int index, Object o) {
        Object key = this.check(o);
        Element child = (Element)o;
        if (child.getParent() != null) {
            throw new IllegalArgumentException("child is already contained");
        }
        if (this.m_childrenMap.containsKey(key)) {
            throw new IllegalArgumentException("duplicate key: " + key);
        }
        this.m_children.add(index, child);
        this.m_childrenMap.put(key, child);
        child.setParent(this.m_parent);
    }

    public Object get(int index) {
        return this.m_children.get(index);
    }

    public int size() {
        return this.m_children.size();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        Object key = this.check(o);
        Element child = (Element)o;
        if (!this.equals(child.getParent())) {
            throw new IllegalArgumentException("child does not belong to this parent");
        }
        this.m_children.remove(o);
        this.m_childrenMap.remove(key);
        child.setParent(null);
        return true;
    }

    public Object[] toArray() {
        return this.m_children.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.m_children.toArray(a);
    }

    public Object get(Object key) {
        return this.m_childrenMap.get(key);
    }

    public boolean containsKey(Object key) {
        return this.m_childrenMap.containsKey(key);
    }

    public String toString() {
        return this.m_children.toString();
    }
}

