/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.engine.rdbms;

import com.redhat.persistence.RecordSet;
import com.redhat.persistence.Signature;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.engine.rdbms.RDBMSEngine;
import com.redhat.persistence.engine.rdbms.ResultCycle;
import com.redhat.persistence.engine.rdbms.StatementLifecycle;
import com.redhat.persistence.metadata.Adapter;
import com.redhat.persistence.metadata.ObjectType;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

class RDBMSRecordSet
extends RecordSet {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/engine/rdbms/RDBMSRecordSet.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$redhat$persistence$RecordSet == null ? (class$com$redhat$persistence$RecordSet = RDBMSRecordSet.class$("com.redhat.persistence.RecordSet")) : class$com$redhat$persistence$RecordSet));
    private final RDBMSEngine m_engine;
    private final ResultCycle m_rc;
    static /* synthetic */ Class class$com$redhat$persistence$RecordSet;

    RDBMSRecordSet(Signature sig, RDBMSEngine engine, ResultCycle rc) {
        super(sig);
        if (rc == null) {
            throw new IllegalArgumentException("null result set");
        }
        this.m_engine = engine;
        this.m_rc = rc;
    }

    ResultSet getResultSet() {
        return this.m_rc.getResultSet();
    }

    String getColumn(Path p) {
        return this.getSignature().getColumn(p);
    }

    public boolean next() {
        return this.m_rc.next();
    }

    public Object get(Path p) {
        StatementLifecycle cycle = this.m_rc.getLifecycle();
        try {
            ObjectType type = this.getSignature().getProperty(p).getType();
            Adapter ad = type.getRoot().getAdapter(type);
            String column = this.getColumn(p);
            if (cycle != null) {
                cycle.beginGet(column);
            }
            Object result = ad.fetch(this.m_rc.getResultSet(), column);
            if (cycle != null) {
                cycle.endGet(result);
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)(p + "(" + column + ") -> " + result));
            }
            return result;
        }
        catch (SQLException e) {
            if (cycle != null) {
                cycle.endGet(e);
            }
            throw new Error("error fetching path (" + p + "): " + e.getMessage());
        }
    }

    public void close() {
        this.m_rc.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

