/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.redhat.persistence.Event;
import com.redhat.persistence.ObjectData;
import com.redhat.persistence.ObjectEvent;
import com.redhat.persistence.PropertyData;
import com.redhat.persistence.PropertyEvent;
import com.redhat.persistence.Session;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import java.util.Iterator;

public class DeleteEvent
extends ObjectEvent {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/DeleteEvent.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    DeleteEvent(Session ssn, Object obj) {
        super(ssn, obj);
    }

    public void dispatch(Event.Switch sw) {
        sw.onDelete(this);
    }

    void activate() {
        super.activate();
        ObjectType type = this.getSession().getObjectType(this.getObject());
        Iterator it = type.getProperties().iterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            PropertyData pd = this.getObjectData().getPropertyData(prop);
            if (pd == null) continue;
            if (!prop.isNullable()) {
                pd.transferNotNullDependentEvents(this);
            }
            if (prop.isCollection()) {
                Iterator evs = this.getSession().getEventStream().getCurrentEvents(this.getObject(), prop).iterator();
                while (evs.hasNext()) {
                    ((PropertyEvent)evs.next()).addDependent(this);
                }
                continue;
            }
            PropertyEvent ev = this.getSession().getEventStream().getLastEvent(this.getObject(), prop);
            if (ev == null) continue;
            ev.addDependent(this);
        }
        this.getObjectData().setState(ObjectData.SENILE);
    }

    void sync() {
        super.sync();
        this.getObjectData().setState(ObjectData.DEAD);
    }

    String getName() {
        return "delete";
    }
}

