/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.webdevsupport;

import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.webdevsupport.QueryInfo;
import com.arsdigita.webdevsupport.RequestInfo;
import com.arsdigita.webdevsupport.WebDevSupport;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class QueryLog
implements Dispatcher {
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$webdevsupport$QueryLog == null ? (class$com$arsdigita$webdevsupport$QueryLog = QueryLog.class$("com.arsdigita.webdevsupport.QueryLog")) : class$com$arsdigita$webdevsupport$QueryLog).getName());
    private ParameterModel m_request_id = new IntegerParameter("request_id");
    private ParameterModel m_query_id = new IntegerParameter("query_id");
    private static Perl5Util s_util = new Perl5Util();
    static /* synthetic */ Class class$com$arsdigita$webdevsupport$QueryLog;

    public void dispatch(HttpServletRequest req, HttpServletResponse resp, RequestContext ctx) throws IOException, ServletException {
        Integer request_id = (Integer)this.m_request_id.transformValue(req);
        Integer query_id = (Integer)this.m_query_id.transformValue(req);
        RequestInfo ri = WebDevSupport.getInstance().getRequest(request_id);
        ListIterator iter = ri == null ? new ArrayList().iterator() : ri.getQueries();
        resp.setContentType("text/plain");
        PrintWriter w = resp.getWriter();
        while (iter.hasNext()) {
            QueryInfo info = (QueryInfo)iter.next();
            Integer id = new Integer(info.getID());
            Long time = new Long(info.getTime());
            if (query_id != null && !query_id.equals(id)) continue;
            ((Writer)w).write("-- ID: #" + id + "\n");
            ((Writer)w).write("-- Duration: " + time + "ms\n");
            ((Writer)w).write(QueryLog.substituteSQL(info) + ";\n\n\n");
        }
    }

    public static String substituteSQL(QueryInfo info) {
        Perl5Matcher matcher = new Perl5Matcher();
        Perl5Compiler compiler = new Perl5Compiler();
        String query = info.getQuery();
        HashMap vars = info.getBindvars();
        HashSubstitution subst = new HashSubstitution(vars);
        StringBuffer result = new StringBuffer();
        PatternMatcherInput input = new PatternMatcherInput(query);
        try {
            Util.substitute((StringBuffer)result, (PatternMatcher)matcher, (Pattern)compiler.compile("(\\?)"), (Substitution)subst, (PatternMatcherInput)input, (int)-1);
        }
        catch (MalformedPatternException e) {
            throw new UncheckedWrapperException("cannot perform substitution", e);
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HashSubstitution
    implements Substitution {
        private HashMap m_hash;
        private int index = 1;

        public HashSubstitution(HashMap hash) {
            this.m_hash = hash;
        }

        public void appendSubstitution(StringBuffer appendBuffer, MatchResult match, int substitutionCount, PatternMatcherInput originalInput, PatternMatcher matcher, Pattern pattern) {
            Integer key = new Integer(this.index++);
            Object v = this.m_hash.get(key);
            String val = null;
            try {
                val = v == null || "NULL".equals(v) || "null".equals(v) ? "null" : (v instanceof Boolean ? (Boolean.TRUE.equals(v) ? "'1'" : "'0'") : "'" + s_util.substitute("s/'/''/g", v.toString()) + "'");
            }
            catch (MalformedPerl5PatternException e) {
                throw new UncheckedWrapperException("cannot perform substitution", e);
            }
            appendBuffer.append(val);
        }
    }
}

