/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RedirectException;
import com.arsdigita.dispatcher.RequestEvent;
import com.arsdigita.kernel.DatabaseTransaction;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.runtime.Startup;
import com.arsdigita.sitenode.ServletErrorReport;
import com.arsdigita.util.ResourceManager;
import com.arsdigita.web.InternalRequestLocal;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class BaseServlet
extends HttpServlet {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/web/BaseServlet.java#29 $$Author: dan $$DateTime: 2004/05/07 07:20:24 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$BaseServlet == null ? (class$com$arsdigita$web$BaseServlet = BaseServlet.class$("com.arsdigita.web.BaseServlet")) : class$com$arsdigita$web$BaseServlet));
    public static final String REQUEST_URL_ATTRIBUTE;
    static /* synthetic */ Class class$com$arsdigita$web$BaseServlet;

    public void init(ServletConfig sconfig) throws ServletException {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Initializing servlet " + sconfig.getServletName() + " (class: " + ((Object)((Object)this)).getClass().getName() + ")"));
        }
        super.init(sconfig);
        ResourceManager.getInstance().setServletContext(this.getServletContext());
        this.doInit();
    }

    protected void doInit() throws ServletException {
    }

    public void destroy() {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Destroying servlet " + this.getServletConfig().getServletName()));
        }
        this.doDestroy();
    }

    protected void doDestroy() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalService(final HttpServletRequest sreq, final HttpServletResponse sresp) throws ServletException, IOException {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Servicing request " + new URL(sreq).toDebugString()));
        }
        Thread thread = Thread.currentThread();
        thread.setName("client-" + sreq.getRemoteAddr());
        InternalRequestLocal.prepareAll(sreq);
        DispatcherHelper.setRequest(sreq);
        final DatabaseTransaction transaction = new DatabaseTransaction();
        DeveloperSupport.requestStart(new RequestEvent(sreq, sresp, null, true));
        try {
            try {
                transaction.begin();
                final UserContext uc = this.getUserContext(sreq, sresp);
                Web.init(sreq, this.getServletContext(), uc);
                Web.getContext().setRequestURL(this.getRequestURL(sreq));
                final ServletException[] servletException = new ServletException[]{null};
                final IOException[] ioException = new IOException[]{null};
                new KernelExcursion(){

                    protected final void excurse() {
                        this.setLocale(sreq.getLocale());
                        this.setSessionID(sreq.getSession().getId());
                        this.setTransaction(transaction);
                        if (uc.isLoggedIn()) {
                            s_log.debug((Object)"User is logged in; storing user in context record");
                            this.setParty(uc.getUser());
                        }
                        if (s_log.isDebugEnabled()) {
                            s_log.debug((Object)"Finished preparing the context for this request");
                            s_log.debug((Object)("Current state of WebContext:\n" + Web.getContext().getCurrentState()));
                            s_log.debug((Object)Kernel.getContext().getDebugInfo());
                        }
                        try {
                            DeveloperSupport.startStage("BaseServlet.doService");
                            BaseServlet.this.doService(sreq, sresp);
                            SessionManager.getSession().flushAll();
                        }
                        catch (ServletException se) {
                            servletException[0] = se;
                            if (BaseServlet.this.findRedirectSignal(se) != null) {
                                SessionManager.getSession().flushAll();
                            }
                        }
                        catch (IOException ioe) {
                            ioException[0] = ioe;
                        }
                        catch (RedirectSignal rs) {
                            SessionManager.getSession().flushAll();
                            throw rs;
                        }
                        finally {
                            DeveloperSupport.endStage("BaseServlet.doService");
                        }
                    }
                }.run();
                if (servletException[0] != null) {
                    throw servletException[0];
                }
                if (ioException[0] != null) {
                    throw ioException[0];
                }
                transaction.end();
            }
            catch (RedirectSignal rs) {
                this.redirect(sresp, transaction, rs);
                Object var9_15 = null;
                transaction.abort();
                InternalRequestLocal.clearAll();
                if (sresp.isCommitted()) {
                    sresp.flushBuffer();
                }
                DeveloperSupport.requestEnd(new RequestEvent(sreq, sresp, null, false));
                return;
            }
            catch (ServletException se) {
                RedirectSignal rs = this.findRedirectSignal(se);
                if (rs == null) {
                    new ServletErrorReport(se, sreq, sresp).logit();
                    throw se;
                }
                this.redirect(sresp, transaction, rs);
                Object var9_16 = null;
                transaction.abort();
                InternalRequestLocal.clearAll();
                if (sresp.isCommitted()) {
                    sresp.flushBuffer();
                }
                DeveloperSupport.requestEnd(new RequestEvent(sreq, sresp, null, false));
                return;
            }
            catch (IOException ioe) {
                new ServletErrorReport(ioe, sreq, sresp).logit();
                throw ioe;
            }
            catch (RuntimeException re) {
                new ServletErrorReport(re, sreq, sresp).logit();
                throw re;
            }
            catch (Error e) {
                new ServletErrorReport(e, sreq, sresp).logit();
                throw e;
            }
            Object var9_14 = null;
            transaction.abort();
        }
        catch (Throwable throwable) {
            Object var9_17 = null;
            transaction.abort();
            InternalRequestLocal.clearAll();
            if (sresp.isCommitted()) {
                sresp.flushBuffer();
            }
            DeveloperSupport.requestEnd(new RequestEvent(sreq, sresp, null, false));
            throw throwable;
        }
        InternalRequestLocal.clearAll();
        if (sresp.isCommitted()) {
            sresp.flushBuffer();
        }
        DeveloperSupport.requestEnd(new RequestEvent(sreq, sresp, null, false));
    }

    protected void doService(HttpServletRequest sreq, HttpServletResponse sresp) throws ServletException, IOException {
    }

    protected final void doGet(HttpServletRequest sreq, HttpServletResponse sresp) throws ServletException, IOException {
        if (s_log.isDebugEnabled()) {
            s_log.info((Object)("Serving GET request path " + sreq.getPathInfo() + " with servlet " + this.getServletConfig().getServletName() + " (class: " + ((Object)((Object)this)).getClass().getName() + ")"));
        }
        this.internalService(sreq, sresp);
    }

    protected final void doPost(HttpServletRequest sreq, HttpServletResponse sresp) throws ServletException, IOException {
        if (s_log.isDebugEnabled()) {
            s_log.info((Object)("Serving POST request path " + sreq.getPathInfo() + " with servlet " + this.getServletConfig().getServletName() + " (class: " + ((Object)((Object)this)).getClass().getName() + ")"));
        }
        sreq = DispatcherHelper.maybeWrapRequest(sreq);
        this.internalService(sreq, sresp);
    }

    private RedirectSignal findRedirectSignal(ServletException se) {
        Throwable root = se.getRootCause();
        while (root instanceof ServletException) {
            root = ((ServletException)root).getRootCause();
        }
        if (root instanceof RedirectSignal) {
            return (RedirectSignal)root;
        }
        return null;
    }

    private void redirect(HttpServletResponse sresp, DatabaseTransaction transaction, RedirectSignal rs) throws IOException {
        if (rs.isCommitRequested()) {
            transaction.commit();
        } else {
            transaction.abort();
        }
        String url = sresp.encodeRedirectURL(rs.getDestinationURL());
        sresp.sendRedirect(url);
    }

    private URL getRequestURL(HttpServletRequest sreq) {
        URL url = (URL)sreq.getAttribute(REQUEST_URL_ATTRIBUTE);
        if (url == null) {
            url = new URL(sreq);
        }
        return url;
    }

    protected UserContext getUserContext(HttpServletRequest sreq, HttpServletResponse sresp) {
        s_log.debug((Object)"Creating a user context");
        UserContext uc = null;
        try {
            uc = new UserContext(sreq, sresp);
        }
        catch (RedirectException re) {
            s_log.debug((Object)"The user needs to log in again");
            throw new RedirectSignal(re.getRedirectURL(), false);
        }
        return uc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Startup startup = new Startup();
        if (!startup.hasRun()) {
            startup.run();
        }
        REQUEST_URL_ATTRIBUTE = (class$com$arsdigita$web$BaseServlet == null ? (class$com$arsdigita$web$BaseServlet = BaseServlet.class$("com.arsdigita.web.BaseServlet")) : class$com$arsdigita$web$BaseServlet).getName() + ".request_url";
    }
}

