/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.VersionedACSObject;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

class VersionController {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$versioning$VersionController == null ? (class$com$arsdigita$versioning$VersionController = VersionController.class$("com.arsdigita.versioning.VersionController")) : class$com$arsdigita$versioning$VersionController));
    static /* synthetic */ Class class$com$arsdigita$versioning$VersionController;

    VersionController() {
    }

    protected static void autoPropagateMaster(VersionedACSObject obj, VersionedACSObject master) {
        Assert.assertTrue(master.isMaster(), "Object " + master.getOID() + " is the master object");
        VersionController.recursivelyTraverse(obj, master, new TraversalListener(){

            public boolean preorderProcess(DataObject data, VersionedACSObject vobj, VersionedACSObject master) {
                if (!master.equals(vobj.getMaster())) {
                    s_log.info((Object)("Object " + vobj.getID() + " had wrong master object " + vobj.getMaster().getID() + ", setting correct master " + master.getOID()));
                    vobj.setMaster(master);
                    vobj.save();
                }
                return true;
            }

            public boolean postorderProcess(DataObject data, VersionedACSObject vobj, VersionedACSObject master) {
                return true;
            }
        });
    }

    private static void recursivelyTraverse(VersionedACSObject obj, VersionedACSObject master, TraversalListener action) {
        VersionController.recursivelyTraverse(obj, master, new HashSet(), action);
    }

    private static void recursivelyTraverse(VersionedACSObject obj, VersionedACSObject master, HashSet visited, TraversalListener action) {
        DataObject data = DomainServiceInterfaceExposer.getDataObject(obj);
        VersionedACSObject vobj = (VersionedACSObject)DomainObjectFactory.newInstance(data);
        OID oid = vobj.getOID();
        if (visited.contains(oid)) {
            throw new IllegalStateException("The object " + oid + " appears more than once in the " + "containment hierarchy. This indicates that the PDL files " + "for the object or its containters create a loop, " + "such as 'A contains component B, B contains " + "component A'; this is illegal for a variety of reasons.");
        }
        visited.add(oid);
        if (!action.preorderProcess(data, vobj, master)) {
            return;
        }
        ObjectType type = oid.getObjectType();
        Iterator i = type.getProperties();
        while (i.hasNext()) {
            DataAssociation assoc;
            ObjectType childType;
            Object value;
            Property prop = (Property)i.next();
            String propName = prop.getName();
            if (!prop.isComponent() || !prop.isRole() || "master".equals(propName) || (value = data.get(propName)) == null) continue;
            if (value instanceof DataObject) {
                VersionController.traverseDataObject((DataObject)value, master, visited, action);
                continue;
            }
            if (!(value instanceof DataAssociation) || !VersionedACSObject.isSubtype(childType = (assoc = (DataAssociation)value).getObjectType())) continue;
            DataAssociationCursor cur = assoc.getDataAssociationCursor();
            while (cur.next()) {
                DataObject linkData = cur.getLink();
                if (linkData != null) {
                    VersionController.traverseDataObject(linkData, master, visited, action);
                }
                VersionController.traverseDataObject(cur.getDataObject(), master, visited, action);
            }
            cur.close();
        }
        if (!action.postorderProcess(data, vobj, master)) {
            return;
        }
    }

    private static void traverseDataObject(DataObject data, VersionedACSObject master, HashSet visited, TraversalListener action) {
        ObjectType type = data.getObjectType();
        if (VersionedACSObject.isSubtype(type)) {
            VersionedACSObject obj = (VersionedACSObject)DomainObjectFactory.newInstance(data);
            VersionController.recursivelyTraverse(obj, master, visited, action);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface TraversalListener {
        public boolean preorderProcess(DataObject var1, VersionedACSObject var2, VersionedACSObject var3);

        public boolean postorderProcess(DataObject var1, VersionedACSObject var2, VersionedACSObject var3);
    }
}

