/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;

public class Operation {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/versioning/Operation.java#15 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final Type CREATE = new Type("create", 0){

        public void dispatch(Switch sw) {
            sw.onCreate();
        }
    };
    public static final Type SET = new Type("set", 1){

        public void dispatch(Switch sw) {
            sw.onSet();
        }
    };
    public static final Type ADD = new Type("add", 2){

        public void dispatch(Switch sw) {
            sw.onAdd();
        }
    };
    public static final Type REMOVE = new Type("remove", 3){

        public void dispatch(Switch sw) {
            sw.onRemove();
        }
    };
    public static final Type DELETE = new Type("delete", 4){

        public void dispatch(Switch sw) {
            sw.onDelete();
        }
    };
    private Type m_type;
    private OID m_object;
    private Property m_property;
    private Object m_argument;

    Operation(Type type, OID object) {
        this.m_type = type;
        this.m_object = object;
        this.m_property = null;
        this.m_argument = null;
    }

    Operation(Type type, OID object, String property, Object argument) {
        this.m_type = type;
        this.m_object = object;
        this.m_property = object.getObjectType().getProperty(property);
        this.m_argument = argument;
    }

    public Type getType() {
        return this.m_type;
    }

    public OID getObject() {
        return this.m_object;
    }

    public Property getProperty() {
        return this.m_property;
    }

    public Object getArgument() {
        return this.m_argument;
    }

    public static abstract class Type {
        private String m_name;
        private int m_sortKey;

        private Type(String name, int sortKey) {
            this.m_name = name;
            this.m_sortKey = sortKey;
        }

        public abstract void dispatch(Switch var1);

        int sortKey() {
            return this.m_sortKey;
        }

        public String toString() {
            return this.m_name;
        }
    }

    public static interface Switch {
        public void onCreate();

        public void onDelete();

        public void onSet();

        public void onAdd();

        public void onRemove();
    }
}

