/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Graph;
import com.arsdigita.util.GraphEdge;
import com.arsdigita.util.GraphFormatter;
import com.arsdigita.util.GraphSet;
import com.arsdigita.util.Graphs;
import com.arsdigita.versioning.EdgeLabel;
import com.arsdigita.versioning.GraphNode;
import com.arsdigita.versioning.NodeType;
import com.arsdigita.versioning.ObjectTypeMetadata;
import com.redhat.persistence.pdl.VersioningMetadata;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class DevSupport {
    private static final String GRAPH_ATTRS_HEADER = "    node[shape=box,fontsize=8,fontname=verdana,height=0.2,width=0.2,style=filled];\n    ranksep=0.05;\n";
    private static final String GRAPH_ATTRS_FOOTER = "\n    node[fontsize=10];\n    edge[fontsize=9,fontname=verdana,style=solid,minlen=2];\n\n";

    private DevSupport() {
    }

    public static void pdlToDot(NodeFilter filter, PrintWriter writer) {
        GraphSet graph = new GraphSet();
        graph.setLabel("pdl_model");
        Iterator objTypes = SessionManager.getMetadataRoot().getObjectTypes().iterator();
        while (objTypes.hasNext()) {
            ObjectType objType = (ObjectType)objTypes.next();
            if (!filter.test(objType.getQualifiedName(), DevSupport.isReachable(objType))) continue;
            graph.addNode(objType);
            ObjectType supertype = objType.getSupertype();
            if (supertype != null && filter.test(supertype.getQualifiedName(), DevSupport.isReachable(supertype))) {
                graph.addEdge(supertype, objType, "extends");
            }
            Iterator props = objType.getProperties();
            while (props.hasNext()) {
                Property prop = (Property)props.next();
                if (!prop.getType().isCompound()) continue;
                graph.addEdge(objType, prop.getType(), DevSupport.propertyLabel(prop));
            }
        }
        Graphs.printGraph(graph, new ModelFormatter(), writer);
    }

    public static void pdlToDot(NodeFilter filter) {
        DevSupport.pdlToDot(filter, new PrintWriter(System.out, true));
    }

    private static boolean isReachable(ObjectType objType) {
        return !ObjectTypeMetadata.getInstance().isUnreachable(objType);
    }

    public static void versioningGraphToDot(NodeFilter filter, PrintWriter writer) {
        Graph fullGraph = ObjectTypeMetadata.getInstance().getDependenceGraph();
        GraphSet subgraph = new GraphSet();
        subgraph.setLabel("dependence_graph");
        Iterator nodes = fullGraph.getNodes().iterator();
        while (nodes.hasNext()) {
            GraphNode node = (GraphNode)nodes.next();
            ObjectType objType = node.getObjectType();
            if (!filter.test(objType.getQualifiedName(), DevSupport.isReachable(objType))) continue;
            subgraph.addNode(node);
            Iterator edges = fullGraph.getOutgoingEdges(node).iterator();
            while (edges.hasNext()) {
                subgraph.addEdge((Graph.Edge)edges.next());
            }
            if (!DevSupport.isReachable(objType)) continue;
            Iterator props = objType.getProperties();
            while (props.hasNext()) {
                Property prop = (Property)props.next();
                if (!prop.getType().isCompound() || prop.isComponent() || prop.isRequired()) continue;
                GraphNode head = GraphNode.getInstance((ObjectType)prop.getType());
                subgraph.addEdge(new GraphEdge(node, head, new EdgeLabel(prop)));
            }
        }
        Graphs.printGraph(subgraph, new DependenceFormatter(), writer);
    }

    public static void versioningGraphToDot(NodeFilter filter) {
        DevSupport.versioningGraphToDot(filter, new PrintWriter(System.out, true));
    }

    private static String propertyLabel(Property prop) {
        StringBuffer sb = new StringBuffer();
        if (prop.isComponent()) {
            sb.append("cnt");
        } else if (prop.isRequired()) {
            sb.append("rqd");
        } else if (prop.isCollection()) {
            sb.append("0..n");
        } else {
            sb.append("0..1");
        }
        sb.append(":").append(prop.getName());
        return sb.toString();
    }

    static interface NodeFilter {
        public boolean test(String var1, boolean var2);
    }

    private static class DependenceFormatter
    implements GraphFormatter {
        private static final String GRAPH_ATTRS = "    node[shape=box,fontsize=8,fontname=verdana,height=0.2,width=0.2,style=filled];\n    ranksep=0.05;\n    edge[style=invis];\n    versioned -> coversioned;\n    coversioned -> recoverable;\n    recoverable -> unreachable;\n    unreachable -> qualifiers;\n\n    subgraph cluster_legend {\n      label=\"Legend\";\n      fontsize=11;\n\n      versioned[label=versioned,fillcolor=Tomato];\n      coversioned[label=coversioned,fillcolor=Pink];\n      recoverable[fillcolor=LemonChiffon];\n      unreachable;\n      qualifiers[label=\"rqd: required\\ncnt: component\\nvnd: versioned\\nunv: unversioned\",shape=plaintext];\n    }\n\n    node[fontsize=10];\n    edge[fontsize=9,fontname=verdana,style=solid,minlen=2];\n\n";
        private static final Map COLORS = new HashMap();

        private DependenceFormatter() {
        }

        public String graphAttributes(Graph graph) {
            return GRAPH_ATTRS;
        }

        public String nodeName(Object node) {
            GraphNode graphNode = (GraphNode)node;
            StringBuffer sb = new StringBuffer();
            sb.append("\"");
            sb.append(graphNode.getObjectType().getName()).append("\"");
            return sb.toString();
        }

        public String nodeAttributes(Object node) {
            GraphNode graphNode = (GraphNode)node;
            return (String)COLORS.get(graphNode.getNodeType());
        }

        public String edge(Object edge) {
            if (edge == null) {
                return "extends";
            }
            EdgeLabel label = (EdgeLabel)edge;
            String pLabel = DevSupport.propertyLabel(label.getProperty());
            if (label.isUnversioned()) {
                return "unv," + pLabel;
            }
            if (label.isVersioned()) {
                return "vnd" + pLabel;
            }
            return pLabel;
        }

        static {
            COLORS.put(NodeType.VERSIONED_TYPE, "[fillcolor=Tomato,comment=\"versioned type\"]");
            COLORS.put(NodeType.COVERSIONED_TYPE, "[fillcolor=Pink,comment=\"coversioned type\"]");
            COLORS.put(NodeType.RECOVERABLE, "[fillcolor=LemonChiffon,comment=recoverable]");
            COLORS.put(NodeType.UNREACHABLE, "[comment=unreachable]");
        }
    }

    private static class ModelFormatter
    implements GraphFormatter {
        private static final String GRAPH_ATTRS = "    node[shape=box,fontsize=8,fontname=verdana,height=0.2,width=0.2,style=filled];\n    ranksep=0.05;\n    edge[style=invis];\n    marked -> unmarked;\n    unmarked -> qualifiers;\n    subgraph cluster_legend {\n      label=\"Legend\";\n      fontsize=11;\n\n      marked[label=\"marked\\nversioned\",fillcolor=Wheat];\n      unmarked[label=unmarked];\n      qualifiers[label=\"rqd: required\\ncnt: component\",shape=plaintext];\n    }\n\n    node[fontsize=10];\n    edge[fontsize=9,fontname=verdana,style=solid,minlen=2];\n\n";

        private ModelFormatter() {
        }

        public String graphAttributes(Graph graph) {
            return GRAPH_ATTRS;
        }

        public String nodeName(Object node) {
            ObjectType objType = (ObjectType)node;
            return objType.getName();
        }

        public String nodeAttributes(Object node) {
            ObjectType objType = (ObjectType)node;
            if (VersioningMetadata.getVersioningMetadata().isMarkedVersioned(objType.getQualifiedName())) {
                return "[fillcolor=Wheat]";
            }
            return null;
        }

        public String edge(Object edge) {
            return (String)edge;
        }
    }
}

