/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.parameter;

import com.arsdigita.util.Assert;
import com.arsdigita.util.parameter.Converters;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterError;
import com.arsdigita.util.parameter.ParameterInfo;
import com.arsdigita.util.parameter.ParameterReader;
import com.arsdigita.util.parameter.ParameterWriter;
import org.apache.commons.beanutils.ConversionException;

public abstract class AbstractParameter
implements Parameter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/parameter/AbstractParameter.java#8 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private final String m_name;
    private final Class m_type;
    private final int m_multiplicity;
    private final Object m_default;
    private ParameterInfo m_info;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$util$parameter$ParameterReader;
    static /* synthetic */ Class class$com$arsdigita$util$parameter$ErrorList;
    static /* synthetic */ Class class$java$lang$Object;

    protected AbstractParameter(String name, int multiplicity, Object defaalt, Class type) {
        if (Assert.isEnabled()) {
            Assert.exists(name, class$java$lang$String == null ? (class$java$lang$String = AbstractParameter.class$("java.lang.String")) : class$java$lang$String);
        }
        this.m_name = name;
        this.m_type = type;
        this.m_multiplicity = multiplicity;
        this.m_default = defaalt;
    }

    protected AbstractParameter(String name, int multiplicity, Object defaalt) {
        this(name, multiplicity, defaalt, null);
    }

    protected AbstractParameter(String name, Class type) {
        this(name, 1, null, type);
    }

    public boolean isRequired() {
        return this.m_multiplicity == 1;
    }

    public final String getName() {
        return this.m_name;
    }

    public Object getDefaultValue() {
        return this.m_default;
    }

    public final ParameterInfo getInfo() {
        return this.m_info;
    }

    public final void setInfo(ParameterInfo info) {
        this.m_info = info;
    }

    public final Object read(ParameterReader reader, ErrorList errors) {
        if (Assert.isEnabled()) {
            Assert.exists(reader, class$com$arsdigita$util$parameter$ParameterReader == null ? (class$com$arsdigita$util$parameter$ParameterReader = AbstractParameter.class$("com.arsdigita.util.parameter.ParameterReader")) : class$com$arsdigita$util$parameter$ParameterReader);
            Assert.exists(errors, class$com$arsdigita$util$parameter$ErrorList == null ? (class$com$arsdigita$util$parameter$ErrorList = AbstractParameter.class$("com.arsdigita.util.parameter.ErrorList")) : class$com$arsdigita$util$parameter$ErrorList);
        }
        return this.doRead(reader, errors);
    }

    protected Object doRead(ParameterReader reader, ErrorList errors) {
        String string = reader.read(this, errors);
        if (string == null) {
            return null;
        }
        return this.unmarshal(string, errors);
    }

    protected Object unmarshal(String value, ErrorList errors) {
        if (Assert.isEnabled()) {
            Assert.exists(value, class$java$lang$String == null ? (class$java$lang$String = AbstractParameter.class$("java.lang.String")) : class$java$lang$String);
            Assert.exists(errors, class$java$lang$String == null ? (class$java$lang$String = AbstractParameter.class$("java.lang.String")) : class$java$lang$String);
        }
        try {
            return Converters.convert(this.m_type, value);
        }
        catch (ConversionException ce) {
            errors.add(new ParameterError((Parameter)this, ce));
            return null;
        }
    }

    public final void validate(Object value, ErrorList errors) {
        Assert.exists(errors, class$com$arsdigita$util$parameter$ErrorList == null ? (class$com$arsdigita$util$parameter$ErrorList = AbstractParameter.class$("com.arsdigita.util.parameter.ErrorList")) : class$com$arsdigita$util$parameter$ErrorList);
        if (value == null) {
            if (this.isRequired()) {
                ParameterError error = new ParameterError((Parameter)this, "The value must not be null");
                errors.add(error);
            }
        } else {
            this.doValidate(value, errors);
        }
    }

    protected void doValidate(Object value, ErrorList errors) {
        if (Assert.isEnabled()) {
            Assert.exists(value, class$java$lang$Object == null ? (class$java$lang$Object = AbstractParameter.class$("java.lang.Object")) : class$java$lang$Object);
            Assert.exists(errors, class$com$arsdigita$util$parameter$ErrorList == null ? (class$com$arsdigita$util$parameter$ErrorList = AbstractParameter.class$("com.arsdigita.util.parameter.ErrorList")) : class$com$arsdigita$util$parameter$ErrorList);
        }
    }

    public final void write(ParameterWriter writer, Object value) {
        Assert.exists(writer);
        this.doWrite(writer, value);
    }

    protected void doWrite(ParameterWriter writer, Object value) {
        writer.write(this, this.marshal(value));
    }

    protected String marshal(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public String toString() {
        return super.toString() + "," + this.getName() + "," + this.isRequired();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

