/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.util.Assert;
import com.arsdigita.util.Graph;
import com.arsdigita.util.GraphEdge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphSet
implements Graph {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private Set m_nodes = new HashSet();
    private Map m_outgoingEdges = new HashMap();
    private Map m_incomingEdges = new HashMap();
    private String m_label = "directed_graph";

    public Graph copy() {
        GraphSet newGraph = new GraphSet();
        Iterator nodes = this.getNodes().iterator();
        while (nodes.hasNext()) {
            Object node = nodes.next();
            newGraph.addNode(node);
            Iterator edges = this.getOutgoingEdges(node).iterator();
            while (edges.hasNext()) {
                Graph.Edge edge = (Graph.Edge)edges.next();
                newGraph.addEdge(edge.getTail(), edge.getHead(), edge.getLabel());
            }
        }
        newGraph.setLabel(this.getLabel());
        return newGraph;
    }

    public void setLabel(String label) {
        Assert.assertTrue(label != null, "label is not null");
        this.m_label = label;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void addNode(Object name) {
        this.m_nodes.add(name);
    }

    public boolean hasNode(Object nodeName) {
        return this.m_nodes.contains(nodeName);
    }

    public boolean hasEdge(Graph.Edge edge) {
        return this.outgoingEdges(edge.getTail()).contains(edge);
    }

    public int nodeCount() {
        return this.m_nodes.size();
    }

    public void addEdge(Graph.Edge edge) {
        this.m_nodes.add(edge.getTail());
        this.m_nodes.add(edge.getHead());
        this.outgoingEdges(edge.getTail()).add(edge);
        this.incomingEdges(edge.getHead()).add(edge);
    }

    public void addEdge(Object tail, Object head, Object label) {
        this.addEdge(new GraphEdge(tail, head, label));
    }

    public List getNodes() {
        return new ArrayList(this.m_nodes);
    }

    public boolean removeNode(Object nodeName) {
        boolean hasNode = this.m_nodes.remove(nodeName);
        if (hasNode) {
            Set in;
            Set out = (Set)this.m_outgoingEdges.remove(nodeName);
            if (out != null) {
                Iterator it = out.iterator();
                while (it.hasNext()) {
                    Graph.Edge e = (Graph.Edge)it.next();
                    this.incomingEdges(e.getHead()).remove(e);
                }
            }
            if ((in = (Set)this.m_incomingEdges.remove(nodeName)) != null) {
                Iterator it = in.iterator();
                while (it.hasNext()) {
                    Graph.Edge e = (Graph.Edge)it.next();
                    this.outgoingEdges(e.getTail()).remove(e);
                }
            }
        }
        return hasNode;
    }

    public boolean removeEdge(Object tail, Object head, Object label) {
        return this.removeEdge(new GraphEdge(tail, head, label));
    }

    public boolean removeEdge(Graph.Edge edge) {
        boolean hasEdge = this.outgoingEdges(edge.getTail()).remove(edge);
        if (hasEdge) {
            this.incomingEdges(edge.getHead()).remove(edge);
        }
        return hasEdge;
    }

    public void removeAll() {
        this.m_nodes.clear();
        this.m_outgoingEdges.clear();
        this.m_incomingEdges.clear();
    }

    private Set outgoingEdges(Object nodeName) {
        HashSet edges = (HashSet)this.m_outgoingEdges.get(nodeName);
        if (edges == null) {
            edges = new HashSet(4);
            this.m_outgoingEdges.put(nodeName, edges);
        }
        return edges;
    }

    private static String objToString(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public List getOutgoingEdges(Object node) {
        Assert.assertTrue(this.hasNode(node), GraphSet.objToString(node));
        return new ArrayList(this.outgoingEdges(node));
    }

    public int outgoingEdgeCount(Object node) {
        Assert.assertTrue(this.hasNode(node), GraphSet.objToString(node));
        return this.outgoingEdges(node).size();
    }

    public int incomingEdgeCount(Object node) {
        Assert.assertTrue(this.hasNode(node), GraphSet.objToString(node));
        return this.incomingEdges(node).size();
    }

    private Set incomingEdges(Object nodeName) {
        HashSet edges = (HashSet)this.m_incomingEdges.get(nodeName);
        if (edges == null) {
            edges = new HashSet();
            this.m_incomingEdges.put(nodeName, edges);
        }
        return edges;
    }

    public List getIncomingEdges(Object node) {
        Assert.assertTrue(this.hasNode(node), GraphSet.objToString(node));
        return new ArrayList(this.incomingEdges(node));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("graph ").append(this.getLabel()).append(" {");
        sb.append(LINE_SEP);
        ArrayList sortedNodes = new ArrayList(this.m_nodes);
        Collections.sort(sortedNodes);
        Iterator nodes = sortedNodes.iterator();
        while (nodes.hasNext()) {
            Object node = nodes.next();
            Iterator edges = this.getOutgoingEdges(node).iterator();
            while (edges.hasNext()) {
                Graph.Edge edge = (Graph.Edge)edges.next();
                sb.append("    ");
                sb.append(GraphSet.objToString(node)).append(" -> ");
                sb.append(GraphSet.objToString(edge.getHead()));
                sb.append("[label=\"").append(edge.getLabel());
                sb.append("\"];");
                sb.append(LINE_SEP);
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

