/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.ui.permissions.PermissionsConstants;
import com.arsdigita.ui.permissions.PermissionsPane;
import com.arsdigita.util.StringUtils;

public class UserSearchForm
extends Form
implements FormProcessListener,
PermissionsConstants {
    private PermissionsPane m_parent;
    private TextField m_search;

    public UserSearchForm(PermissionsPane parent) {
        this(PermissionsConstants.DEFAULT_PRIVILEGES, parent);
    }

    public UserSearchForm(PrivilegeDescriptor[] privs, PermissionsPane parent) {
        super("SearchUsers", new SimpleContainer());
        this.m_parent = parent;
        this.setMethod("post");
        this.addProcessListener(this);
        this.add(new Label(PermissionsConstants.SEARCH_LABEL));
        this.add(new Label("&nbsp;", false));
        StringParameter searchParam = new StringParameter("query");
        this.m_search = new TextField(searchParam);
        this.m_search.addValidationListener(new NotEmptyValidationListener());
        this.m_search.setSize(20);
        this.add(this.m_search, 4);
        Submit submit = new Submit("submit");
        submit.setButtonLabel(PermissionsConstants.SEARCH_BUTTON);
        this.add(submit, 1);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        String search = (String)data.get("query");
        search = StringUtils.stripWhiteSpace(search);
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.RetrieveUsers");
        query.setParameter("excludeGroupId", null);
        Filter f = query.addFilter("searchName like lower('%' || :searchQuery || '%')");
        f.set("searchQuery", search);
        if (query.isEmpty()) {
            this.m_parent.showNoResults(state);
        } else {
            state.setValue(this.getSearchString(), data.get("query"));
            state.setValue(this.getPrivilegeModel(), this.getPrivileges());
            this.m_parent.showGrant(state);
        }
        query.close();
    }

    private ParameterModel getSearchString() {
        return this.m_parent.getSearchString();
    }

    private ParameterModel getPrivilegeModel() {
        return this.m_parent.getPrivilegeParam();
    }

    private Object[] getPrivileges() {
        return this.m_parent.getPrivileges();
    }

    public TextField getSearchWidget() {
        return this.m_search;
    }
}

