/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.form.Password;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.EmailParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.URLParameter;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.EmailList;
import com.arsdigita.ui.admin.URLValidationListener;
import com.arsdigita.ui.login.PasswordValidationListener;
import java.math.BigDecimal;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;

class UserForm
extends Form
implements FormValidationListener,
AdminConstants {
    protected TextField m_firstName;
    protected TextField m_lastName;
    protected TextField m_primaryEmail;
    protected TextField m_additionalEmail;
    protected Password m_password;
    protected Password m_confirmPassword;
    protected TextField m_question;
    protected TextField m_answer;
    protected TextField m_url;
    protected TextField m_screenName;
    protected EmailList m_emailList;
    private PasswordValidationListener m_pwListener = new PasswordValidationListener();
    private NotEmptyValidationListener m_notNullListener = new NotEmptyValidationListener();

    public UserForm(String formName) {
        super(formName);
        this.addValidationListener(this);
        int max = 60;
        this.m_firstName = new TextField(new StringParameter("firstname"));
        this.m_firstName.setMaxLength(max);
        this.m_firstName.setSize(20);
        this.m_firstName.addValidationListener(new NotEmptyValidationListener());
        this.m_firstName.addValidationListener(new StringLengthValidationListener(max));
        this.add(AdminConstants.USER_FORM_LABEL_FIRST_NAME);
        this.add(this.m_firstName);
        this.m_lastName = new TextField(new StringParameter("lastname"));
        this.m_lastName.setMaxLength(max);
        this.m_lastName.setSize(25);
        this.m_lastName.addValidationListener(new NotEmptyValidationListener());
        this.m_lastName.addValidationListener(new StringLengthValidationListener(max));
        this.add(AdminConstants.USER_FORM_LABEL_LAST_NAME);
        this.add(this.m_lastName);
        this.m_password = new Password(new StringParameter("password"));
        this.add(AdminConstants.USER_FORM_LABEL_PASSWORD);
        this.add(this.m_password);
        this.m_confirmPassword = new Password(new StringParameter("password_confirmation"));
        this.add(AdminConstants.USER_FORM_LABEL_PASSWORD_CONFIRMATION);
        this.add(this.m_confirmPassword);
        this.m_question = new TextField(new StringParameter("question"));
        this.m_question.setSize(50);
        this.add(AdminConstants.USER_FORM_LABEL_QUESTION);
        this.add(this.m_question);
        this.m_answer = new TextField(new StringParameter("answer"));
        this.m_answer.setSize(30);
        this.add(AdminConstants.USER_FORM_LABEL_ANSWER);
        this.add(this.m_answer);
        this.m_primaryEmail = new TextField(new EmailParameter("email"));
        this.m_primaryEmail.addValidationListener(new NotEmptyValidationListener());
        this.add(AdminConstants.USER_FORM_LABEL_PRIMARY_EMAIL);
        this.add(this.m_primaryEmail);
        this.m_emailList = new EmailList();
        this.add(AdminConstants.USER_FORM_LABEL_ADDITIONAL_EMAIL_LIST);
        this.add(this.m_emailList);
        this.m_additionalEmail = new TextField(new EmailParameter("additional_email"));
        this.add(AdminConstants.USER_FORM_LABEL_ADDITIONAL_EMAIL);
        this.add(this.m_additionalEmail);
        this.m_screenName = new TextField(new StringParameter("screenname"));
        this.add(AdminConstants.USER_FORM_LABEL_SCREEN_NAME);
        this.add(this.m_screenName);
        this.m_url = new TextField(new URLParameter("url"));
        this.m_url.setSize(50);
        this.m_url.setDefaultValue("http://");
        this.m_url.addValidationListener(new URLValidationListener());
        this.add(AdminConstants.USER_FORM_LABEL_URL);
        this.add(this.m_url);
        this.add(new Label(""));
        this.add(new Submit(AdminConstants.USER_FORM_SUBMIT));
    }

    public void validate(FormSectionEvent event) throws FormProcessException {
        PageState ps = event.getPageState();
        FormData data = event.getFormData();
        HttpServletRequest req = ps.getRequest();
        BigDecimal userID = (BigDecimal)ps.getValue(AdminConstants.USER_ID_PARAM);
        if (userID == null) {
            this.m_pwListener.validate(new ParameterEvent(event.getSource(), data.getParameter("password")));
            this.m_notNullListener.validate(new ParameterEvent(event.getSource(), data.getParameter("password_confirmation")));
            String password = (String)this.m_password.getValue(ps);
            String confirm = (String)this.m_confirmPassword.getValue(ps);
            if (password != null && confirm != null) {
                if (!password.equals(confirm)) {
                    data.addError("password_confirmation", (String)AdminConstants.USER_FORM_ERROR_PASSWORD_NOT_MATCH.localize(req));
                }
            } else if (password != null || confirm != null) {
                data.addError("password_confirmation", (String)AdminConstants.USER_FORM_ERROR_PASSWORD_NOT_MATCH.localize(req));
            }
        }
        String answer = (String)this.m_answer.getValue(ps);
        if (userID == null) {
            if (answer == null || answer.trim().length() == 0) {
                data.addError("answer", (String)AdminConstants.USER_FORM_ERROR_ANSWER_NULL.localize(req));
            }
        } else if (answer != null && answer.length() > 0 && answer.trim().length() == 0) {
            data.addError("answer", (String)AdminConstants.USER_FORM_ERROR_ANSWER_NULL.localize(req));
        }
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.RetrieveUsers");
        query.setParameter("excludeGroupId", null);
        String email = null;
        if (this.m_primaryEmail.getValue(ps) != null) {
            email = ((InternetAddress)this.m_primaryEmail.getValue(ps)).getAddress();
        }
        String screenName = (String)this.m_screenName.getValue(ps);
        Filter filter = query.addFilter("primaryEmail = :email or screenName = :sn");
        filter.set("email", email);
        filter.set("sn", screenName);
        if (userID != null) {
            Filter userIDfilter = query.addFilter("userID != :userID");
            userIDfilter.set("userID", userID);
        }
        while (query.next()) {
            if (screenName != null && screenName.equals(query.get("screenName"))) {
                data.addError("screenname", (String)AdminConstants.USER_FORM_ERROR_SCREEN_NAME_NOT_UNIQUE.localize(req));
            }
            if (email == null || !email.equals(query.get("primaryEmail"))) continue;
            data.addError("email", (String)AdminConstants.USER_FORM_ERROR_PRIMARY_EMAIL_NOT_UNIQUE.localize(req));
        }
    }

    protected void hideSecurityInfo(PageState state) {
        this.setSecurityInfo(state, false);
    }

    protected void showSecurityInfo(PageState state) {
        this.setSecurityInfo(state, true);
    }

    private void setSecurityInfo(PageState state, boolean isVisible) {
        AdminConstants.USER_FORM_LABEL_PASSWORD.setVisible(state, isVisible);
        AdminConstants.USER_FORM_LABEL_PASSWORD_CONFIRMATION.setVisible(state, isVisible);
        AdminConstants.USER_FORM_LABEL_QUESTION.setVisible(state, isVisible);
        AdminConstants.USER_FORM_LABEL_ANSWER.setVisible(state, isVisible);
        this.m_password.setVisible(state, isVisible);
        this.m_confirmPassword.setVisible(state, isVisible);
        this.m_question.setVisible(state, isVisible);
        this.m_answer.setVisible(state, isVisible);
    }
}

