/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.rebop;

import com.arsdigita.toolbox.rebop.AbstractDrawable;
import com.arsdigita.toolbox.rebop.FormattedText;
import com.arsdigita.toolbox.rebop.GenericDrawable;
import com.arsdigita.toolbox.rebop.WrappedRun;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public class StyledText
extends AbstractDrawable
implements GenericDrawable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/rebop/StyledText.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Vector m_runs = new Vector();
    private Vector m_wrappedRuns = null;
    private Font m_baseFont = new Font("SansSerif", 0, 12);

    public void addRun(FormattedText run) {
        this.m_runs.addElement(run);
    }

    public void setWrappedRuns(Vector runs) {
        this.m_wrappedRuns = runs;
    }

    public Vector getWrappedRuns() {
        return this.m_wrappedRuns;
    }

    public void draw(Graphics g, int x, int y, int width, int height) {
        if (null != this.m_wrappedRuns && 0 < this.m_wrappedRuns.size()) {
            StyledText.drawWrappedText(g, this.m_baseFont, this.m_runs, new Dimension(width, height), x + this.getXOffset(), false, null, null, this.m_wrappedRuns);
            return;
        }
        if (null == g || 0 == this.m_runs.size()) {
            return;
        }
        FormattedText firstRun = (FormattedText)this.m_runs.elementAt(0);
        firstRun.updateGraphics(g);
        Point startPoint = new Point(x + this.getXOffset(), y + this.getYOffset());
        Dimension preferredDimension = new Dimension(0, 0);
        StyledText.drawWrappedText(g, this.m_baseFont, this.m_runs, new Dimension(width, height), x + this.getXOffset(), false, startPoint, preferredDimension, this.m_wrappedRuns);
    }

    public void setBaseFont(Font font) {
        this.m_baseFont = font;
    }

    public FormattedText getFormattedTextAt(int index) {
        if (index < this.m_runs.size()) {
            FormattedText ft = (FormattedText)this.m_runs.elementAt(index);
            return ft;
        }
        return null;
    }

    public void setFormattedTextAt(int index, FormattedText ft) {
        if (index == this.m_runs.size()) {
            this.m_runs.addElement(ft);
        } else if (index < this.m_runs.size()) {
            this.m_runs.setElementAt(ft, index);
        }
    }

    public void setRunColor(int runIndex, Color color) {
        FormattedText ft = this.getFormattedTextAt(runIndex);
        if (null != ft) {
            ft.setColor(color);
        }
    }

    public String toString() {
        if (0 >= this.m_runs.size()) {
            return "";
        }
        if (1 == this.m_runs.size()) {
            FormattedText ft = (FormattedText)this.m_runs.elementAt(0);
            return ft.getString();
        }
        StringBuffer buffer = new StringBuffer();
        FormattedText ft = null;
        for (int i = 0; i < this.m_runs.size(); ++i) {
            ft = (FormattedText)this.m_runs.elementAt(i);
            buffer.append(ft.getString());
        }
        return buffer.toString();
    }

    public Dimension getPreferredSize(Graphics g, int width, int height) {
        Point startPoint = new Point(this.getXOffset(), this.getYOffset());
        Dimension preferredDimension = new Dimension(0, 0);
        StyledText.drawWrappedText(g, this.m_baseFont, this.m_runs, new Dimension(width, height), this.getXOffset(), true, startPoint, preferredDimension, null);
        return preferredDimension;
    }

    public static void drawWrappedText(Graphics g, Font baseFont, Vector runs, Dimension size, int leftMargin, boolean measureOnly, Point startPoint, Dimension preferredDimension, Vector wrappedRuns) {
        int initialY = startPoint.y;
        int initialX = startPoint.x;
        Dimension tempDimension = null;
        int i = 0;
        if (null != preferredDimension) {
            tempDimension = new Dimension(0, 0);
        }
        if (null != wrappedRuns && 0 < wrappedRuns.size()) {
            for (i = 0; i < wrappedRuns.size(); ++i) {
                WrappedRun run = (WrappedRun)wrappedRuns.elementAt(i);
                run.updateGraphics(g);
                run.draw(g);
            }
            return;
        }
        Vector currentRunWrap = null;
        if (null != wrappedRuns) {
            currentRunWrap = new Vector();
        }
        for (i = 0; i < runs.size(); ++i) {
            FormattedText currentRun = (FormattedText)runs.elementAt(i);
            currentRun.updateGraphics(g);
            if (null == currentRun.getFont() && null != baseFont) {
                g.setFont(baseFont);
            }
            FormattedText.drawWrappedText(g, currentRun.getString(), size, leftMargin, measureOnly, startPoint, tempDimension, currentRunWrap);
            if (null == wrappedRuns) continue;
            for (int j = 0; j < currentRunWrap.size(); ++j) {
                wrappedRuns.addElement(currentRunWrap.elementAt(j));
            }
            currentRunWrap.removeAllElements();
        }
        if (null != preferredDimension) {
            FontMetrics fm = g.getFontMetrics();
            int ascent = fm.getHeight();
            int descent = fm.getMaxDescent();
            preferredDimension.height = startPoint.y + ascent + descent;
            preferredDimension.width = initialY == startPoint.y ? startPoint.x - initialX : size.width;
        }
    }
}

