/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.rebop;

import com.arsdigita.toolbox.rebop.FormattedText;
import com.arsdigita.toolbox.rebop.GenericComponent;
import com.arsdigita.toolbox.rebop.GenericDrawable;
import com.arsdigita.toolbox.rebop.StyledText;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Vector;

public class GenericLabel
extends GenericComponent {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/rebop/GenericLabel.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Dimension m_preferredSize = null;
    private boolean m_updateSize = false;
    private boolean m_useOffset = false;
    private int m_xOffset = 2;
    private int m_yOffset = 2;
    private boolean m_wrapText = true;
    private Vector m_wrappedRuns = null;

    public GenericLabel(String text) {
        this.setFont(new Font("SansSerif", 0, 12));
        this.updateText(text);
    }

    public GenericLabel() {
        this.setFont(new Font("SansSerif", 0, 12));
    }

    public void setFont(Font font) {
        super.setFont(font);
        StyledText stx = this.getStyledText();
        stx.setBaseFont(font);
    }

    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.m_updateSize = true;
    }

    public void setDrawable(GenericDrawable drawable) {
        if (!(drawable instanceof StyledText)) {
            return;
        }
        super.setDrawable(drawable);
        StyledText stx = this.getStyledText();
        super.setName(stx.toString());
        this.m_updateSize = true;
    }

    public void addFormattedText(Font font, Color color, String string) {
        StyledText sText = this.getStyledText();
        sText.addRun(new FormattedText(font, color, string));
        this.m_updateSize = true;
    }

    private void updateText(String text) {
        super.setName(text);
        StyledText styledText = new StyledText();
        FormattedText run = new FormattedText(text);
        styledText.addRun(run);
        this.setDrawable(styledText);
    }

    protected StyledText getStyledText() {
        StyledText sText = (StyledText)this.getDrawable();
        if (null == sText) {
            if (null != this.getName()) {
                this.updateText(this.getName());
                sText = (StyledText)this.getDrawable();
            } else {
                sText = new StyledText();
                this.setDrawable(sText);
            }
        }
        return sText;
    }

    public void setWrappedRuns(Vector wrappedRuns) {
        this.m_wrappedRuns = wrappedRuns;
        if (null != this.m_wrappedRuns) {
            StyledText stx = this.getStyledText();
            stx.setWrappedRuns(this.m_wrappedRuns);
        }
    }

    public Vector getWrappedRuns() {
        return this.m_wrappedRuns;
    }

    public void setUseOffset(boolean useOffset) {
        StyledText sText = this.getStyledText();
        if (useOffset) {
            sText.setXOffset(sText.getXOffset() + this.m_xOffset);
            sText.setYOffset(sText.getYOffset() + this.m_yOffset);
        } else {
            if (sText.getXOffset() >= this.m_xOffset) {
                sText.setXOffset(sText.getXOffset() - this.m_xOffset);
            } else {
                sText.setXOffset(0);
            }
            if (sText.getYOffset() >= this.m_yOffset) {
                sText.setYOffset(sText.getYOffset() - this.m_yOffset);
            } else {
                sText.setYOffset(0);
            }
        }
    }

    public void setXOffset(int xOffset) {
        this.m_xOffset = xOffset;
    }

    public void setYOffset(int yOffset) {
        this.m_yOffset = yOffset;
    }

    public void setName(String text) {
        this.updateText(text);
        this.updatePreferredSize();
        this.setSize(this.getPreferredSize());
    }

    public void setForeground(Color fgColor) {
        super.setForeground(fgColor);
        StyledText stx = this.getStyledText();
        stx.setRunColor(0, fgColor);
    }

    public String toString() {
        return this.getName();
    }

    public Dimension getPreferredSize() {
        if (this.m_updateSize) {
            this.updatePreferredSize();
        }
        if (null == this.m_preferredSize) {
            return this.getSize();
        }
        return this.m_preferredSize;
    }

    public void addNotify() {
        super.addNotify();
        if (null == this.m_preferredSize) {
            this.m_updateSize = true;
        }
    }

    private void updatePreferredSize() {
        Graphics g = this.getGraphics();
        if (null != g) {
            Dimension size = this.getSize();
            StyledText sText = this.getStyledText();
            this.m_preferredSize = sText.getPreferredSize(g, size.width, size.height);
            this.m_updateSize = false;
        }
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public void forceUpdateSize() {
        this.m_updateSize = true;
    }
}

