/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.lucene;

import com.arsdigita.persistence.OID;
import com.arsdigita.search.BaseDocument;
import com.arsdigita.search.IndexerType;
import com.arsdigita.search.ResultSet;
import com.arsdigita.search.lucene.LuceneSearch;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

class LuceneResultSet
implements ResultSet {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$search$lucene$LuceneResultSet == null ? (class$com$arsdigita$search$lucene$LuceneResultSet = LuceneResultSet.class$("com.arsdigita.search.lucene.LuceneResultSet")) : class$com$arsdigita$search$lucene$LuceneResultSet));
    private LuceneSearch m_search;
    private long m_count;
    private long m_queryTime;
    static /* synthetic */ Class class$com$arsdigita$search$lucene$LuceneResultSet;

    public LuceneResultSet(LuceneSearch search) {
        this.m_search = search;
        Date start = new Date();
        this.m_count = search.size();
        Date end = new Date();
        this.m_queryTime = end.getTime() - start.getTime();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Result set count is " + this.m_count + ", query duration " + this.m_queryTime));
        }
    }

    public Iterator getDocuments(long offset, long count) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Paginating at offset " + offset + " for " + count + " rows"));
        }
        if (count == 0L) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new LuceneIterator(this.m_search, offset, count);
    }

    public void close() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Closing search result set");
        }
        this.m_search.close();
    }

    public String getEngine() {
        return IndexerType.LUCENE.getKey();
    }

    public long getCount() {
        return this.m_count;
    }

    public long getQueryTime() {
        return this.m_queryTime;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LuceneIterator
    implements Iterator {
        private LuceneSearch m_search;
        private long m_count;
        private boolean m_hasNext;

        public LuceneIterator(LuceneSearch search, long offset, long count) {
            this.m_search = search;
            this.m_count = count;
            do {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Peek object " + offset));
                }
                this.m_hasNext = this.m_search.next();
            } while (offset-- > 0L);
        }

        public boolean hasNext() {
            return this.m_hasNext;
        }

        public Object next() {
            Assert.truth(this.m_hasNext, "hasNext");
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Got next object");
            }
            BaseDocument result = new BaseDocument(new OID(this.m_search.getType(), (Object)this.m_search.getID()), this.m_search.getLocale(), this.m_search.getTitle(), this.m_search.getSummary(), this.m_search.getCreationDate(), null, this.m_search.getLastModifiedDate(), null, new BigDecimal((double)this.m_search.getScore() * 100.0).setScale(0, 4));
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Peeking at result count is " + this.m_count));
            }
            this.m_hasNext = this.m_count-- > 0L ? this.m_search.next() : false;
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException("cannot remove items");
        }
    }
}

