/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portal;

import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.bebop.portal.PortletRenderer;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.portal.Portal;
import com.arsdigita.portal.PortletType;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class Portlet
extends Resource {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/portal/Portlet.java#17 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.portal.Portlet";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$portal$Portlet == null ? (class$com$arsdigita$portal$Portlet = Portlet.class$("com.arsdigita.portal.Portlet")) : class$com$arsdigita$portal$Portlet));
    static /* synthetic */ Class class$com$arsdigita$portal$Portlet;
    static /* synthetic */ Class class$com$arsdigita$portal$PortletType;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$arsdigita$portal$Portal;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected Portlet(DataObject dataObject) {
        super(dataObject);
    }

    public Portlet(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public static Portlet createPortlet(PortletType portletType, Resource parent) {
        Assert.exists(portletType, class$com$arsdigita$portal$PortletType == null ? (class$com$arsdigita$portal$PortletType = Portlet.class$("com.arsdigita.portal.PortletType")) : class$com$arsdigita$portal$PortletType);
        return (Portlet)Resource.createResource(portletType, portletType.getTitle(), parent);
    }

    public static Portlet createPortlet(String portletObjectType, Resource parent) {
        Assert.exists(portletObjectType, class$java$lang$String == null ? (class$java$lang$String = Portlet.class$("java.lang.String")) : class$java$lang$String);
        PortletType portletType = PortletType.retrievePortletTypeForPortlet(portletObjectType);
        return Portlet.createPortlet(portletType, parent);
    }

    public void beforeSave() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("In before save on " + this + " " + this.get("sortKey")), (Throwable)new RuntimeException("trace"));
        }
        super.beforeSave();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Done before save on " + this + " " + this.get("sortKey")));
        }
    }

    public void afterSave() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("In after save on " + this + " " + this.get("sortKey")), (Throwable)new RuntimeException("trace"));
        }
        super.afterSave();
        Assert.exists(this.get("sortKey"), class$java$lang$Integer == null ? (class$java$lang$Integer = Portlet.class$("java.lang.Integer")) : class$java$lang$Integer);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Middle after save on " + this + " " + this.get("sortKey")));
        }
        if (this.getParentResource() == null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Setting permission context for portlet " + this + " to " + this.getPortal()));
            }
            KernelExcursion ex = new KernelExcursion(){

                protected void excurse() {
                    this.setEffectiveParty(Kernel.getSystemParty());
                    PermissionService.setContext(Portlet.this, Portlet.this.getPortal());
                }
            };
            ex.run();
        } else if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Not setting permission context");
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Done after save on " + this + " " + this.get("sortKey")));
        }
    }

    public static Portlet retrievePortlet(BigDecimal id) {
        return (Portlet)Resource.retrieveResource(id);
    }

    public static Portlet retrievePortlet(OID oid) {
        return (Portlet)Resource.retrieveResource(oid);
    }

    public static Portlet retrievePortlet(DataObject dataObject) {
        return (Portlet)Resource.retrieveResource(dataObject);
    }

    public String getProfile() {
        String profile = this.getPortletType().getProfile();
        Assert.exists(profile, class$java$lang$String == null ? (class$java$lang$String = Portlet.class$("java.lang.String")) : class$java$lang$String);
        return profile;
    }

    public void setPortal(Portal portal) {
        Assert.exists(portal, class$com$arsdigita$portal$Portal == null ? (class$com$arsdigita$portal$Portal = Portlet.class$("com.arsdigita.portal.Portal")) : class$com$arsdigita$portal$Portal);
        this.setAssociation("portal", portal);
    }

    public Portal getPortal() {
        DataObject dataObject = (DataObject)this.get("portal");
        Portal portal = Portal.retrieve(dataObject);
        Assert.exists(portal, class$com$arsdigita$portal$Portal == null ? (class$com$arsdigita$portal$Portal = Portlet.class$("com.arsdigita.portal.Portal")) : class$com$arsdigita$portal$Portal);
        return portal;
    }

    public void setPortletType(PortletType portletType) {
        this.setResourceType(portletType);
    }

    public PortletType getPortletType() {
        DataObject dataObject = (DataObject)this.get("resourceType");
        dataObject.specialize("com.arsdigita.portal.PortletType");
        PortletType portletType = PortletType.retrievePortletType(dataObject);
        Assert.exists(portletType, class$com$arsdigita$portal$PortletType == null ? (class$com$arsdigita$portal$PortletType = Portlet.class$("com.arsdigita.portal.PortletType")) : class$com$arsdigita$portal$PortletType);
        return portletType;
    }

    public PortletRenderer getPortletRenderer() {
        AbstractPortletRenderer portletRenderer = this.doGetPortletRenderer();
        portletRenderer.setTitle(this.getTitle());
        portletRenderer.setCellNumber(this.getCellNumber());
        portletRenderer.setSortKey(this.getSortKey());
        portletRenderer.setProfile(this.getProfile());
        return portletRenderer;
    }

    protected AbstractPortletRenderer doGetPortletRenderer() {
        throw new UnsupportedOperationException("Portlet does not provide a default implementation of doGetPortletRenderer, since it wouldn't be of any use.  If you get this error, it may be because the portal could not find the specific domain class for a portlet using the DomainObjectFactory.");
    }

    protected long newExpirationDate() {
        return System.currentTimeMillis() + 300000L;
    }

    protected ACSObject getContainer() {
        return null;
    }

    protected boolean isContainerModified() {
        return false;
    }

    public void setCellNumber(int cellNumber) {
        this.set("cellNumber", new Integer(cellNumber));
    }

    public int getCellNumber() {
        Integer cellNumber = (Integer)this.get("cellNumber");
        Assert.exists(cellNumber, class$java$lang$Integer == null ? (class$java$lang$Integer = Portlet.class$("java.lang.Integer")) : class$java$lang$Integer);
        return cellNumber;
    }

    public void setSortKey(int sortKey) {
        this.set("sortKey", new Integer(sortKey));
    }

    public int getSortKey() {
        Integer sortKey = (Integer)this.get("sortKey");
        Assert.exists(sortKey, class$java$lang$Integer == null ? (class$java$lang$Integer = Portlet.class$("java.lang.Integer")) : class$java$lang$Integer);
        return sortKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

