/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence.pdl;

import com.arsdigita.db.DbHelper;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.pdl.PDL;
import com.arsdigita.persistence.pdl.PDLException;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.pdl.DDLWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TestPDLGenerator {
    public static final void main(String[] args) throws PDLException {
        HashMap options = new HashMap();
        args = PDL.CMD.parse(options, args);
        BasicConfigurator.configure();
        if (Boolean.TRUE.equals(options.get("-debug"))) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        } else if (Boolean.TRUE.equals(options.get("-verbose"))) {
            Logger.getRootLogger().setLevel(Level.INFO);
        } else if (Boolean.TRUE.equals(options.get("-quiet"))) {
            Logger.getRootLogger().setLevel(Level.ERROR);
        } else {
            Logger.getRootLogger().setLevel(Level.FATAL);
        }
        String database = (String)options.get("-database");
        if ("postgres".equalsIgnoreCase(database)) {
            DbHelper.setDatabase(2);
        } else {
            DbHelper.setDatabase(1);
        }
        List library = PDL.findPDLFiles((File[])options.get("-library-path"));
        List files = PDL.findPDLFiles((File[])options.get("-path"));
        files.addAll(Arrays.asList(args));
        if (files.size() < 1) {
            throw new PDLException(PDL.CMD.usage());
        }
        File debugDir = (File)options.get("-generate-events");
        if (debugDir != null) {
            if (!debugDir.exists() || !debugDir.isDirectory()) {
                throw new PDLException("No such directory: " + debugDir);
            }
            PDL.setDebugDirectory(debugDir);
        }
        PDL.compilePDLFiles(library);
        PDL.compilePDLFiles(files);
        Map map = TestPDLGenerator.getTestDirectoryMapping(files);
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String directory = (String)it.next();
            List filesForDirectory = (List)map.get(directory);
            TestPDLGenerator.generateSQL(directory, filesForDirectory, options);
        }
    }

    private static Map getTestDirectoryMapping(List files) {
        HashMap<String, LinkedList<String>> map = new HashMap<String, LinkedList<String>>();
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            String file = (String)iterator.next();
            String directory = file.substring(0, file.lastIndexOf(47));
            LinkedList<String> dirList = (LinkedList<String>)map.get(directory);
            if (null == dirList) {
                dirList = new LinkedList<String>();
                map.put(directory, dirList);
            }
            dirList.add(file);
        }
        return map;
    }

    private static void generateSQL(String directory, List files, Map options) throws PDLException {
        MetadataRoot root = MetadataRoot.getMetadataRoot();
        String ddlDir = (String)options.get("-generate-ddl");
        if (ddlDir != null) {
            String subdir = directory.substring(directory.indexOf("/com/"));
            ddlDir = ddlDir + subdir;
            HashSet sqlFiles = new HashSet();
            File sqldir = (File)options.get("-sqldir");
            if (sqldir != null) {
                PDL.findSQLFiles(sqldir, sqlFiles);
            }
            File file = new File(ddlDir);
            file.mkdirs();
            DDLWriter writer = new DDLWriter(ddlDir, sqlFiles);
            writer.setTestPDL(true);
            ArrayList tables = new ArrayList(root.getRoot().getTables());
            Iterator it = tables.iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                if (files.contains(root.getRoot().getFilename(table))) continue;
                it.remove();
            }
            try {
                writer.write(tables);
            }
            catch (IOException ioe) {
                throw new PDLException(ioe.getMessage());
            }
        }
    }
}

