/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence.pdl;

import com.arsdigita.db.DbHelper;
import com.arsdigita.persistence.Utilities;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.pdl.DirSource;
import com.arsdigita.persistence.pdl.FileSource;
import com.arsdigita.persistence.pdl.NameFilter;
import com.arsdigita.persistence.pdl.PDLCompiler;
import com.arsdigita.persistence.pdl.PDLException;
import com.arsdigita.persistence.pdl.PDLFilter;
import com.arsdigita.persistence.pdl.PDLOutputter;
import com.arsdigita.persistence.pdl.ZipSource;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.cmd.BooleanSwitch;
import com.arsdigita.util.cmd.CommandLine;
import com.arsdigita.util.cmd.FileSwitch;
import com.arsdigita.util.cmd.PathSwitch;
import com.arsdigita.util.cmd.StringSwitch;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.pdl.DDLWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipFile;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class PDL {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/pdl/PDL.java#32 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$persistence$pdl$PDL == null ? (class$com$arsdigita$persistence$pdl$PDL = PDL.class$("com.arsdigita.persistence.pdl.PDL")) : class$com$arsdigita$persistence$pdl$PDL));
    private static boolean s_quiet = false;
    private PDLCompiler m_pdlc = new PDLCompiler();
    protected static final CommandLine CMD = new CommandLine((class$com$arsdigita$persistence$pdl$PDL == null ? (class$com$arsdigita$persistence$pdl$PDL = PDL.class$("com.arsdigita.persistence.pdl.PDL")) : class$com$arsdigita$persistence$pdl$PDL).getName(), null);
    private static String s_debugDirectory;
    private static final Set SUFFIXES;
    static /* synthetic */ Class class$com$arsdigita$persistence$pdl$PDL;

    public void generateMetadata(MetadataRoot root) {
        this.m_pdlc.emit(root);
    }

    public void load(Reader r, String filename) throws PDLException {
        this.m_pdlc.parse(r, filename);
    }

    public void load(File f) throws PDLException {
        try {
            this.load(new FileReader(f), f.toString());
        }
        catch (FileNotFoundException e) {
            throw new PDLException(e.getMessage());
        }
    }

    public void load(String filename) throws PDLException {
        this.load(new File(filename));
    }

    public void loadResource(String s) throws PDLException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(s);
        if (is == null) {
            throw new PDLException("No such resource: " + s);
        }
        this.load(new InputStreamReader(is), s);
    }

    public static final void main(String[] args) throws PDLException {
        HashMap options = new HashMap();
        args = CMD.parse(options, args);
        BasicConfigurator.configure();
        if (Boolean.TRUE.equals(options.get("-debug"))) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        } else if (Boolean.TRUE.equals(options.get("-verbose"))) {
            Logger.getRootLogger().setLevel(Level.INFO);
        } else if (Boolean.TRUE.equals(options.get("-quiet"))) {
            Logger.getRootLogger().setLevel(Level.ERROR);
            s_quiet = true;
        } else {
            Logger.getRootLogger().setLevel(Level.FATAL);
        }
        String database = (String)options.get("-database");
        if ("postgres".equalsIgnoreCase(database)) {
            DbHelper.setDatabase(2);
        } else {
            DbHelper.setDatabase(1);
        }
        final NameFilter filter = new NameFilter(DbHelper.getDatabaseSuffix(), "pdl");
        final Collection[] output = new Collection[]{new HashSet()};
        PDLFilter tracker = new PDLFilter(){

            public Collection accept(Collection names) {
                Collection result = filter.accept(names);
                output[0].addAll(result);
                return result;
            }
        };
        PDLCompiler compiler = new PDLCompiler();
        PDL.parse(compiler, (File[])options.get("-library-path"), (PDLFilter)filter);
        PDL.parse(compiler, (File[])options.get("-path"), tracker);
        PDL.parse(compiler, args, tracker);
        if (output[0].size() < 1) {
            if (s_quiet) {
                return;
            }
            PDL.usage();
        }
        HashSet<File> pdlFiles = new HashSet<File>();
        Iterator it = output[0].iterator();
        while (it.hasNext()) {
            File pdlFile = new File((String)it.next());
            pdlFiles.add(pdlFile);
        }
        File debugDir = (File)options.get("-generate-events");
        if (debugDir != null) {
            if (!debugDir.exists() || !debugDir.isDirectory()) {
                throw new PDLException("No such directory: " + debugDir);
            }
            PDL.setDebugDirectory(debugDir);
        }
        MetadataRoot root = MetadataRoot.getMetadataRoot();
        compiler.emit(root);
        String ddlDir = (String)options.get("-generate-ddl");
        if (ddlDir != null) {
            HashSet sqlFiles = new HashSet();
            File sqldir = (File)options.get("-sqldir");
            if (sqldir != null) {
                PDL.findSQLFiles(sqldir, sqlFiles);
            }
            DDLWriter writer = new DDLWriter(ddlDir, sqlFiles);
            if (Boolean.TRUE.equals(Boolean.valueOf((String)options.get("-testddl")))) {
                writer.setTestPDL(true);
            }
            ArrayList tables = new ArrayList(root.getRoot().getTables());
            Iterator it2 = tables.iterator();
            while (it2.hasNext()) {
                Table table = (Table)it2.next();
                File tableFile = new File(root.getRoot().getFilename(table));
                if (pdlFiles.contains(tableFile)) continue;
                it2.remove();
            }
            try {
                writer.write(tables);
            }
            catch (IOException ioe) {
                throw new PDLException(ioe.getMessage());
            }
        }
    }

    private static void parse(PDLCompiler compiler, String[] path, PDLFilter filter) {
        File[] fpath = new File[path.length];
        for (int i = 0; i < path.length; ++i) {
            fpath[i] = new File(path[i]);
        }
        PDL.parse(compiler, fpath, filter);
    }

    private static void parse(PDLCompiler compiler, File[] path, PDLFilter filter) {
        ArrayList<String> filenames = new ArrayList<String>();
        for (int i = 0; i < path.length; ++i) {
            File f = path[i];
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                new DirSource(f, filter).parse(compiler);
                continue;
            }
            if (f.isFile() && (f.getName().endsWith(".jar") || f.getName().endsWith(".zip"))) {
                try {
                    new ZipSource(new ZipFile(f), filter).parse(compiler);
                    continue;
                }
                catch (IOException e) {
                    throw new UncheckedWrapperException(e);
                }
            }
            filenames.add(f.getPath());
        }
        Collection accepted = filter.accept(filenames);
        Iterator it = accepted.iterator();
        while (it.hasNext()) {
            new FileSource((String)it.next()).parse(compiler);
        }
    }

    private static final void usage() throws PDLException {
        throw new PDLException(CMD.usage());
    }

    public static void setDebugDirectory(File directory) {
        s_debugDirectory = directory.getPath();
    }

    public static void setDebugDirectory(String directory) {
        s_debugDirectory = directory;
    }

    public static String getDebugDirectory() {
        return s_debugDirectory;
    }

    public static MetadataRoot loadDirectory(File dir) {
        List files = PDL.findPDLFiles(dir);
        s_log.warn((Object)("Found " + files.size() + " files in the " + dir.toString() + " directory."));
        try {
            return PDL.compilePDLFiles(files);
        }
        catch (PDLException ex) {
            throw new UncheckedWrapperException("error while trying to compile PDL files", ex);
        }
    }

    public static List findPDLFiles(File[] path) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < path.length; ++i) {
            s_log.debug((Object)("Loading default PDL files from " + path[i]));
            PDL.findPDLFiles(path[i], result);
        }
        return result;
    }

    public static List findPDLFiles(File dir) {
        ArrayList files = new ArrayList();
        PDL.findFiles(dir, files, "pdl", false);
        return files;
    }

    public static void findPDLFiles(File base, Collection files) {
        PDL.findFiles(base, files, "pdl", false);
    }

    public static void findSQLFiles(File base, Collection files) {
        PDL.findFiles(base, files, "sql", true);
    }

    private static void findFiles(File base, Collection files, final String extension, boolean trimPath) {
        if (!base.exists()) {
            s_log.warn((Object)("Skipping directory " + base + " since it doesn't exist"));
            return;
        }
        Assert.assertTrue(base.isDirectory(), "directory " + base + " is directory");
        final String suffix = DbHelper.getDatabaseSuffix();
        Stack<File> dirs = new Stack<File>();
        dirs.push(base);
        HashSet<String> toAdd = new HashSet<String>();
        while (dirs.size() > 0) {
            String path;
            File dir = (File)dirs.pop();
            if ("upgrade".equalsIgnoreCase(dir.getName())) {
                s_log.debug((Object)"Skipping upgrade directory");
                continue;
            }
            File[] listing = dir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String name = file.getName();
                    String base = PDL.base(name);
                    String sfx = PDL.suffix(name);
                    String ext = PDL.extension(name);
                    if (ext != null && ext.equals(extension)) {
                        if (sfx != null) {
                            return sfx.equals(suffix);
                        }
                        return true;
                    }
                    return false;
                }
            });
            Arrays.sort(listing, new Comparator(){

                public int compare(Object o1, Object o2) {
                    File f1 = (File)o1;
                    File f2 = (File)o2;
                    return f1.getAbsolutePath().compareTo(f2.getAbsolutePath());
                }
            });
            toAdd.clear();
            for (int i = 0; i < listing.length; ++i) {
                if (listing[i].isDirectory()) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Found subdir " + listing[i]));
                    }
                    dirs.push(listing[i]);
                    continue;
                }
                try {
                    path = listing[i].getCanonicalPath();
                    if (trimPath) {
                        int index = path.lastIndexOf(File.separator);
                        if (index != -1) {
                            path = path.substring(index + 1);
                        }
                        path = PDL.base(path) + "." + extension;
                    }
                    toAdd.add(path);
                    continue;
                }
                catch (IOException e) {
                    throw new UncheckedWrapperException("cannot get file path", e);
                }
            }
            if (suffix != null) {
                Iterator it = toAdd.iterator();
                while (it.hasNext()) {
                    String shadow;
                    path = (String)it.next();
                    if (!path.equals(shadow = PDL.base(path) + "." + suffix + "." + extension) && toAdd.contains(shadow)) {
                        if (s_log.isDebugEnabled()) {
                            s_log.debug((Object)("Ignoring " + path + " because it is shadowed by  " + shadow));
                        }
                        it.remove();
                        continue;
                    }
                    if (!s_log.isDebugEnabled()) continue;
                    s_log.debug((Object)("Found file " + path));
                }
            }
            files.addAll(toAdd);
        }
    }

    private static final String base(String path) {
        String suffix = PDL.suffix(path);
        if (suffix == null) {
            return PDL.basename(path);
        }
        return PDL.basename(PDL.basename(path));
    }

    private static final String suffix(String path) {
        String result = PDL.extension(PDL.basename(path));
        if (SUFFIXES.contains(result)) {
            return result;
        }
        return null;
    }

    private static final String extension(String path) {
        if (path == null) {
            return null;
        }
        int idx = path.lastIndexOf(46);
        if (idx > -1) {
            return path.substring(idx + 1);
        }
        return null;
    }

    private static final String basename(String path) {
        int idx = path.lastIndexOf(46);
        if (idx > -1) {
            return path.substring(0, idx);
        }
        return path;
    }

    public static MetadataRoot compilePDLFiles(Collection files) throws PDLException {
        StringBuffer sb = new StringBuffer();
        PDL pdl = new PDL();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            String file = (String)it.next();
            try {
                pdl.load(file);
            }
            catch (PDLException e) {
                sb.append(file).append(": ");
                sb.append(e.getMessage()).append(Utilities.LINE_BREAK);
            }
        }
        if (sb.length() == 0) {
            pdl.generateMetadata(MetadataRoot.getMetadataRoot());
            if (s_debugDirectory != null) {
                try {
                    PDLOutputter.writePDL(MetadataRoot.getMetadataRoot(), new File(s_debugDirectory));
                }
                catch (IOException ex) {
                    s_log.error((Object)"There was a problem generating debugging output", (Throwable)ex);
                }
            }
        } else {
            throw new PDLException(sb.toString());
        }
        return MetadataRoot.getMetadataRoot();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CMD.addSwitch(new PathSwitch("-library-path", "PDL files appearing in this path will be searched for unresolved dependencies found in the files to be processed", new File[0]));
        CMD.addSwitch(new PathSwitch("-path", "PDL files appearing in this path will be processed", new File[0]));
        CMD.addSwitch(new BooleanSwitch("-validate", "validate PDL", Boolean.FALSE));
        CMD.addSwitch(new StringSwitch("-generate-ddl", "generate ddl and write it to the specified directory", null));
        CMD.addSwitch(new FileSwitch("-generate-events", "if present PDL will be written to the specified directory containing the MDSQL generated events", null));
        CMD.addSwitch(new StringSwitch("-database", "target database", null));
        CMD.addSwitch(new FileSwitch("-sqldir", "sql directory", null));
        CMD.addSwitch(new BooleanSwitch("-debug", "sets logging to DEBUG", Boolean.FALSE));
        CMD.addSwitch(new BooleanSwitch("-verbose", "sets logging to INFO", Boolean.FALSE));
        CMD.addSwitch(new BooleanSwitch("-quiet", "sets logging to ERROR and does not complain if no PDL files are found", Boolean.FALSE));
        CMD.addSwitch(new StringSwitch("-testddl", "no clue", null));
        s_debugDirectory = null;
        SUFFIXES = new HashSet();
        String[] sfxs = DbHelper.getDatabaseSuffixes();
        for (int i = 0; i < sfxs.length; ++i) {
            SUFFIXES.add(sfxs[i]);
        }
    }
}

