/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence;

import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.persistence.metadata.SimpleType;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class OID {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/OID.java#15 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ObjectType m_type;
    private Map m_values = new HashMap();
    private static MessageFormat m_format = new MessageFormat("[{0}:{1}]");
    private static final Logger m_log = Logger.getLogger((Class)(class$com$arsdigita$persistence$OID == null ? (class$com$arsdigita$persistence$OID = OID.class$("com.arsdigita.persistence.OID")) : class$com$arsdigita$persistence$OID));
    static /* synthetic */ Class class$com$arsdigita$persistence$OID;

    public OID(ObjectType type) {
        this.m_type = type;
    }

    public OID(ObjectType type, Object value) {
        this(type);
        Iterator it = type.getKeyProperties();
        if (!it.hasNext()) {
            throw new PersistenceException("Empty object key: " + type);
        }
        Property prop = (Property)it.next();
        if (it.hasNext()) {
            throw new PersistenceException("This object type has a compound key.");
        }
        String attr = prop.getName();
        this.set(attr, value);
    }

    private static final ObjectType lookup(String typeName) {
        ObjectType type = MetadataRoot.getMetadataRoot().getObjectType(typeName);
        if (type == null) {
            throw new PersistenceException("No such type " + typeName);
        }
        return type;
    }

    public OID(String typeName) {
        this(OID.lookup(typeName));
    }

    public OID(String typeName, Object value) {
        this(OID.lookup(typeName), value);
    }

    public OID(String typeName, int value) {
        this(typeName, (Object)new BigDecimal((double)value));
    }

    public OID(ObjectType type, int value) {
        this(type, (Object)new BigDecimal((double)value));
    }

    public void set(String propertyName, Object value) {
        Property prop = this.m_type.getProperty(propertyName);
        if (prop == null) {
            throw new PersistenceException("no such property: " + propertyName + " for type " + this.m_type.getName());
        }
        if (prop.isAttribute() && value != null) {
            SimpleType expectedType = (SimpleType)prop.getType();
            if (!expectedType.getJavaClass().isAssignableFrom(value.getClass())) {
                throw new PersistenceException("expected " + expectedType.getJavaClass() + "actual type " + value.getClass());
            }
        } else if (value != null) {
            if (value instanceof DataObject) {
                ObjectType ot = (ObjectType)prop.getType();
                DataObject dobj = (DataObject)value;
                ObjectType.verifySubtype(ot, dobj.getObjectType());
            } else {
                throw new PersistenceException("expected DataObject for property " + propertyName + " but got " + value.getClass());
            }
        }
        if (this.hasProperty(propertyName)) {
            throw new PersistenceException(propertyName + " is already set to " + this.get(propertyName));
        }
        this.m_values.put(propertyName, value);
    }

    public Object get(String propertyName) {
        return this.m_values.get(propertyName);
    }

    public boolean hasProperty(String name) {
        return this.m_values.containsKey(name);
    }

    Map getProperties() {
        return this.m_values;
    }

    public boolean isInitialized() {
        Iterator it = this.m_type.getKeyProperties();
        while (it.hasNext()) {
            if (this.m_values.containsKey(((Property)it.next()).getName())) continue;
            return false;
        }
        return true;
    }

    public int getNumberOfProperties() {
        return this.getProperties().size();
    }

    public boolean arePropertiesNull() {
        Iterator i = this.getProperties().values().iterator();
        while (i.hasNext()) {
            if (i.next() == null) continue;
            return false;
        }
        return true;
    }

    public ObjectType getDataObjectType() {
        return this.getObjectType();
    }

    public ObjectType getObjectType() {
        return this.m_type;
    }

    void specialize(ObjectType subtype) {
        ObjectType.verifySubtype(this.m_type, subtype);
        this.m_type = subtype;
    }

    public String toString() {
        String fullType = this.m_type.getQualifiedName();
        Object[] args = new Object[]{fullType, this.getProperties().toString()};
        return m_format.format(args);
    }

    public static OID valueOf(String s) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(s, "[:{}],");
        if (st.countTokens() < 2 && (st = new StringTokenizer(URLDecoder.decode(s), "[:{}],")).countTokens() < 2) {
            throw new IllegalArgumentException("Invalid OID '" + s + "'. It must have at least the object " + "type and the value");
        }
        String type = st.nextToken();
        try {
            OID oid = new OID(type);
            int nTokens = 0;
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                int index = nextToken.indexOf("=");
                String key = nextToken.substring(0, index);
                String value = nextToken.substring(index + 1);
                if (nTokens > 0) {
                    key = key.substring(1);
                }
                boolean bigDecimal = true;
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if ('0' <= c && c <= '9' || i == 0 && c == '-') continue;
                    bigDecimal = false;
                    break;
                }
                if (bigDecimal) {
                    oid.set(key, new BigDecimal(value));
                } else {
                    oid.set(key, value);
                }
                ++nTokens;
            }
            return oid;
        }
        catch (PersistenceException e) {
            throw new IllegalArgumentException("Invalid OID '" + s + "'. The type specified [" + type + "] is not defined");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof OID) {
            OID oid = (OID)obj;
            return this.m_type.getBasetype().equals(oid.m_type.getBasetype()) && ((Object)this.m_values).equals(oid.m_values);
        }
        return false;
    }

    public int hashCode() {
        return this.m_type.getBasetype().hashCode() + ((Object)this.m_values).hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

